/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.Arrays;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractSolutionExporter
extends LoggingMain {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = "xml";
    protected SolutionDao solutionDao;

    public AbstractSolutionExporter(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    protected File getInputDir() {
        return new File(this.solutionDao.getDataDir(), "solved");
    }

    protected File getOutputDir() {
        return new File(this.solutionDao.getDataDir(), "export");
    }

    protected String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    protected abstract String getOutputFileSuffix();

    public void convertAll() {
        File inputDir = this.getInputDir();
        if (!inputDir.exists()) {
            throw new IllegalStateException("The directory inputDir (" + inputDir.getAbsolutePath() + ") does not exist.");
        }
        File outputDir = this.getOutputDir();
        outputDir.mkdirs();
        File[] inputFiles = inputDir.listFiles();
        Arrays.sort(inputFiles, new ProblemFileComparator());
        for (File inputFile : inputFiles) {
            String inputFileName = inputFile.getName();
            if (!inputFileName.endsWith("." + this.getInputFileSuffix())) continue;
            Solution solution = this.solutionDao.readSolution(inputFile);
            String outputFileName = inputFileName.substring(0, inputFileName.length() - this.getInputFileSuffix().length()) + this.getOutputFileSuffix();
            File outputFile = new File(outputDir, outputFileName);
            this.writeSolution(solution, outputFile);
        }
    }

    public abstract void writeSolution(Solution var1, File var2);

    public static abstract class OutputBuilder
    extends LoggingMain {
    }
}

