/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.cloner.PlanningCloneable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.ExamBefore;
import org.optaplanner.examples.examination.domain.solver.ExamCoincidence;

@PlanningEntity
@XStreamAlias(value="Exam")
public class Exam
extends AbstractPersistable
implements PlanningCloneable<Exam> {
    private Topic topic;
    private ExamCoincidence examCoincidence = null;
    private ExamBefore examBefore = null;
    private Period period;
    private Room room;

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public ExamCoincidence getExamCoincidence() {
        return this.examCoincidence;
    }

    public void setExamCoincidence(ExamCoincidence examCoincidence) {
        this.examCoincidence = examCoincidence;
    }

    public ExamBefore getExamBefore() {
        return this.examBefore;
    }

    public void setExamBefore(ExamBefore examBefore) {
        this.examBefore = examBefore;
    }

    @PlanningVariable(valueRangeProviderRefs={"periodRange"})
    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    @PlanningVariable(valueRangeProviderRefs={"roomRange"})
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public boolean isCoincidenceLeader() {
        return this.examCoincidence == null || this.examCoincidence.getFirstExam() == this;
    }

    public int getTopicDuration() {
        return this.getTopic().getDuration();
    }

    public int getTopicStudentSize() {
        return this.getTopic().getStudentSize();
    }

    public int getDayIndex() {
        if (this.period == null) {
            return Integer.MIN_VALUE;
        }
        return this.period.getDayIndex();
    }

    public int getPeriodIndex() {
        if (this.period == null) {
            return Integer.MIN_VALUE;
        }
        return this.period.getPeriodIndex();
    }

    public int getPeriodDuration() {
        if (this.period == null) {
            return Integer.MIN_VALUE;
        }
        return this.period.getDuration();
    }

    public boolean isTopicFrontLoadLarge() {
        return this.topic.isFrontLoadLarge();
    }

    public boolean isPeriodFrontLoadLast() {
        if (this.period == null) {
            return false;
        }
        return this.period.isFrontLoadLast();
    }

    public Exam planningClone() {
        Exam clone = new Exam();
        clone.id = this.id;
        clone.topic = this.topic;
        clone.period = this.period;
        clone.room = this.room;
        return clone;
    }

    public String getLabel() {
        return Long.toString(this.topic.getId());
    }

    @Override
    public String toString() {
        return this.topic + " @ " + this.period + " + " + this.room;
    }
}

