/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tennis.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.tennis.domain.Day;
import org.optaplanner.examples.tennis.domain.Team;
import org.optaplanner.examples.tennis.domain.TeamAssignment;
import org.optaplanner.examples.tennis.domain.TennisSolution;
import org.optaplanner.examples.tennis.domain.UnavailabilityPenalty;

public class TennisPanel
extends SolutionPanel {
    private final TimeTablePanel<Day, Team> datesPanel;
    private final TimeTablePanel<Team, Team> confrontationsPanel;

    public TennisPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.datesPanel = new TimeTablePanel();
        tabbedPane.add("Dates", new JScrollPane(this.datesPanel));
        this.confrontationsPanel = new TimeTablePanel();
        tabbedPane.add("Confrontations", new JScrollPane(this.confrontationsPanel));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    @Override
    public void resetPanel(Solution solution) {
        this.datesPanel.reset();
        this.confrontationsPanel.reset();
        TennisSolution tennisSolution = (TennisSolution)solution;
        this.defineGrid(tennisSolution);
        this.fillCells(tennisSolution);
        this.repaint();
    }

    private void defineGrid(TennisSolution tennisSolution) {
        JButton footprint = new JButton("999999");
        footprint.setMargin(new Insets(0, 0, 0, 0));
        int footprintWidth = footprint.getPreferredSize().width;
        this.datesPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Day day : tennisSolution.getDayList()) {
            this.datesPanel.defineColumnHeader(day, footprintWidth);
        }
        this.datesPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.TRAILING_HEADER_COLUMN);
        this.datesPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Team team : tennisSolution.getTeamList()) {
            this.datesPanel.defineRowHeader(team);
        }
        this.datesPanel.defineRowHeader(null);
        this.confrontationsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Team team : tennisSolution.getTeamList()) {
            this.confrontationsPanel.defineColumnHeader(team);
        }
        this.confrontationsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Team team : tennisSolution.getTeamList()) {
            this.confrontationsPanel.defineRowHeader(team);
        }
    }

    private void fillCells(TennisSolution tennisSolution) {
        this.datesPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Team")));
        this.fillDayCells(tennisSolution);
        this.fillTeamCells(tennisSolution);
        this.fillUnavailabilityPenaltyCells(tennisSolution);
        this.fillLectureCells(tennisSolution);
        this.fillConfrontationCells(tennisSolution);
    }

    private void fillDayCells(TennisSolution tennisSolution) {
        for (Day day : tennisSolution.getDayList()) {
            this.datesPanel.addColumnHeader(day, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel(day.getLabel(), 0)));
        }
        this.datesPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.TRAILING_HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Day count")));
    }

    private void fillTeamCells(TennisSolution tennisSolution) {
        Map<Team, Integer> teamToDayCountMap = this.extractTeamToDayCountMap(tennisSolution);
        for (Team team : tennisSolution.getTeamList()) {
            this.datesPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, team, this.createHeaderPanel(new JLabel(team.getLabel())));
            this.datesPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.TRAILING_HEADER_COLUMN, team, this.createHeaderPanel(new JLabel(teamToDayCountMap.get(team) + " days")));
            this.confrontationsPanel.addColumnHeader(team, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel(team.getLabel())));
            this.confrontationsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, team, this.createHeaderPanel(new JLabel(team.getLabel())));
        }
        this.datesPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createHeaderPanel(new JLabel("Unassigned")));
    }

    private Map<Team, Integer> extractTeamToDayCountMap(TennisSolution tennisSolution) {
        HashMap<Team, Integer> teamToDayCountMap = new HashMap<Team, Integer>(tennisSolution.getTeamList().size());
        for (Team team : tennisSolution.getTeamList()) {
            teamToDayCountMap.put(team, 0);
        }
        for (TeamAssignment teamAssignment : tennisSolution.getTeamAssignmentList()) {
            Team team = teamAssignment.getTeam();
            if (team == null) continue;
            int count = (Integer)teamToDayCountMap.get(team);
            teamToDayCountMap.put(team, ++count);
        }
        return teamToDayCountMap;
    }

    private void fillUnavailabilityPenaltyCells(TennisSolution tennisSolution) {
        for (UnavailabilityPenalty unavailabilityPenalty : tennisSolution.getUnavailabilityPenaltyList()) {
            JPanel unavailabilityPanel = new JPanel();
            unavailabilityPanel.setBackground(TangoColorFactory.ALUMINIUM_4);
            this.datesPanel.addCell(unavailabilityPenalty.getDay(), unavailabilityPenalty.getTeam(), unavailabilityPanel);
        }
    }

    private void fillLectureCells(TennisSolution tennisSolution) {
        TangoColorFactory tangoColorFactory = new TangoColorFactory();
        for (TeamAssignment teamAssignment : tennisSolution.getTeamAssignmentList()) {
            Team team = teamAssignment.getTeam();
            Color teamColor = team == null ? TangoColorFactory.SCARLET_1 : tangoColorFactory.pickColor(team);
            this.datesPanel.addCell(teamAssignment.getDay(), team, this.createButton(teamAssignment, teamColor));
        }
    }

    private void fillConfrontationCells(TennisSolution tennisSolution) {
        List<Team> teamList = tennisSolution.getTeamList();
        List<Day> dayList = tennisSolution.getDayList();
        HashMap dayToTeamAssignmentListMap = new HashMap(dayList.size());
        for (Day day : dayList) {
            dayToTeamAssignmentListMap.put(day, new ArrayList());
        }
        for (TeamAssignment teamAssignment : tennisSolution.getTeamAssignmentList()) {
            ((List)dayToTeamAssignmentListMap.get(teamAssignment.getDay())).add(teamAssignment);
        }
        HashMap<List<Team>, Integer> teamPairToConfrontationCountMap = new HashMap<List<Team>, Integer>();
        for (Team team : teamList) {
            for (Team right : teamList) {
                if (team == right) continue;
                List<Team> teamPair = Arrays.asList(team, right);
                teamPairToConfrontationCountMap.put(teamPair, 0);
            }
        }
        for (List list : dayToTeamAssignmentListMap.values()) {
            for (TeamAssignment left : list) {
                for (TeamAssignment right : list) {
                    if (left.getTeam() == right.getTeam()) continue;
                    List<Team> teamPair = Arrays.asList(left.getTeam(), right.getTeam());
                    int confrontationCount = (Integer)teamPairToConfrontationCountMap.get(teamPair);
                    teamPairToConfrontationCountMap.put(teamPair, ++confrontationCount);
                }
            }
        }
        for (Map.Entry entry : teamPairToConfrontationCountMap.entrySet()) {
            List teamPair = (List)entry.getKey();
            int confrontationCount = (Integer)entry.getValue();
            this.confrontationsPanel.addCell((Team)teamPair.get(0), (Team)teamPair.get(1), this.createHeaderPanel(new JLabel(Integer.toString(confrontationCount))));
        }
    }

    private JPanel createHeaderPanel(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private JButton createButton(TeamAssignment teamAssignment, Color color) {
        JButton button = new JButton("Play");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBackground(color);
        return button;
    }
}

