/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.domain.solver;

import java.util.ArrayDeque;
import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;

public class PredecessorsDoneDateUpdatingVariableListener
implements VariableListener<Allocation> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, Allocation allocation) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, Allocation allocation) {
        this.updateAllocation(scoreDirector, allocation);
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, Allocation allocation) {
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, Allocation allocation) {
        this.updateAllocation(scoreDirector, allocation);
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, Allocation allocation) {
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, Allocation allocation) {
    }

    protected void updateAllocation(ScoreDirector scoreDirector, Allocation originalAllocation) {
        ArrayDeque<Allocation> uncheckedSuccessorQueue = new ArrayDeque<Allocation>();
        uncheckedSuccessorQueue.addAll(originalAllocation.getSuccessorAllocationList());
        while (!uncheckedSuccessorQueue.isEmpty()) {
            Allocation allocation = (Allocation)uncheckedSuccessorQueue.remove();
            boolean updated = this.updatePredecessorsDoneDate(scoreDirector, allocation);
            if (!updated) continue;
            uncheckedSuccessorQueue.addAll(allocation.getSuccessorAllocationList());
        }
    }

    protected boolean updatePredecessorsDoneDate(ScoreDirector scoreDirector, Allocation allocation) {
        Integer doneDate = 0;
        for (Allocation predecessorAllocation : allocation.getPredecessorAllocationList()) {
            int endDate = predecessorAllocation.getEndDate();
            doneDate = Math.max(doneDate, endDate);
        }
        if (ObjectUtils.equals((Object)doneDate, (Object)allocation.getPredecessorsDoneDate())) {
            return false;
        }
        scoreDirector.beforeVariableChanged((Object)allocation, "predecessorsDoneDate");
        allocation.setPredecessorsDoneDate(doneDate);
        scoreDirector.afterVariableChanged((Object)allocation, "predecessorsDoneDate");
        return true;
    }
}

