/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.solver.move.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.examples.travelingtournament.domain.Day;
import org.optaplanner.examples.travelingtournament.domain.Match;
import org.optaplanner.examples.travelingtournament.domain.Team;
import org.optaplanner.examples.travelingtournament.domain.TravelingTournament;
import org.optaplanner.examples.travelingtournament.solver.move.MatchChainRotationsMove;

public class MatchChainRotationsMoveFactory
implements MoveListFactory<TravelingTournament> {
    public List<Move> createMoveList(TravelingTournament travelingTournament) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        RotationMovesFactory rotationMovesFactory = new RotationMovesFactory(travelingTournament);
        rotationMovesFactory.addDayRotation(moveList);
        rotationMovesFactory.addTeamRotation(moveList);
        return moveList;
    }

    private static class RotationMovesFactory {
        private List<Day> dayList;
        private List<Team> teamList;
        private List<Match> matchList;
        private Map<Day, Map<Team, Match>> dayTeamMap;
        private Map<Team, Map<Day, Match>> teamDayMap;
        private Map<Team, Map<Team, Match>> homeTeamAwayTeamMap;

        public RotationMovesFactory(TravelingTournament travelingTournament) {
            this.dayList = travelingTournament.getDayList();
            this.teamList = travelingTournament.getTeamList();
            this.matchList = travelingTournament.getMatchList();
            this.createMaps();
        }

        private void createMaps() {
            this.dayTeamMap = new HashMap<Day, Map<Team, Match>>(this.dayList.size());
            for (Day day : this.dayList) {
                this.dayTeamMap.put(day, new LinkedHashMap(this.teamList.size()));
            }
            this.teamDayMap = new HashMap<Team, Map<Day, Match>>(this.teamList.size());
            this.homeTeamAwayTeamMap = new HashMap<Team, Map<Team, Match>>(this.teamList.size());
            for (Team team : this.teamList) {
                this.teamDayMap.put(team, new LinkedHashMap(this.dayList.size()));
                this.homeTeamAwayTeamMap.put(team, new LinkedHashMap(this.teamList.size() - 1));
            }
            for (Match match : this.matchList) {
                Map<Team, Match> subTeamMap = this.dayTeamMap.get(match.getDay());
                subTeamMap.put(match.getHomeTeam(), match);
                subTeamMap.put(match.getAwayTeam(), match);
                this.teamDayMap.get(match.getHomeTeam()).put(match.getDay(), match);
                this.teamDayMap.get(match.getAwayTeam()).put(match.getDay(), match);
                this.homeTeamAwayTeamMap.get(match.getHomeTeam()).put(match.getAwayTeam(), match);
            }
        }

        private Team getOtherTeam(Match match, Team team) {
            return match.getHomeTeam().equals(team) ? match.getAwayTeam() : match.getHomeTeam();
        }

        private void addDayRotation(List<Move> moveList) {
            ListIterator<Day> firstDayIt = this.dayList.listIterator();
            while (firstDayIt.hasNext()) {
                Day firstDay = firstDayIt.next();
                Map<Team, Match> firstDayTeamMap = this.dayTeamMap.get(firstDay);
                ListIterator<Day> secondDayIt = this.dayList.listIterator(firstDayIt.nextIndex());
                while (secondDayIt.hasNext()) {
                    Day secondDay = secondDayIt.next();
                    ArrayList<Match> clonedFirstDayMatchList = new ArrayList<Match>(firstDayTeamMap.values());
                    while (!clonedFirstDayMatchList.isEmpty()) {
                        ArrayList<Match> rotateList = new ArrayList<Match>(4);
                        Match startMatch = (Match)clonedFirstDayMatchList.remove(0);
                        boolean otherInFirst = false;
                        rotateList.add(startMatch);
                        Team startHomeTeam = startMatch.getHomeTeam();
                        Team nextTeamToFind = startMatch.getAwayTeam();
                        while (!startHomeTeam.equals(nextTeamToFind)) {
                            Map<Team, Match> subTeamMap = this.dayTeamMap.get(otherInFirst ? firstDay : secondDay);
                            Match repairMatch = subTeamMap.get(nextTeamToFind);
                            if (otherInFirst) {
                                clonedFirstDayMatchList.remove(repairMatch);
                            }
                            rotateList.add(repairMatch);
                            nextTeamToFind = this.getOtherTeam(repairMatch, nextTeamToFind);
                            otherInFirst = !otherInFirst;
                        }
                        if (rotateList.size() <= 2) continue;
                        List<Match> emptyList = Collections.emptyList();
                        MatchChainRotationsMove rotateMove = new MatchChainRotationsMove(rotateList, emptyList);
                        moveList.add(rotateMove);
                    }
                }
            }
        }

        private void addTeamRotation(List<Move> moveList) {
            ListIterator<Team> firstTeamIt = this.teamList.listIterator();
            while (firstTeamIt.hasNext()) {
                Team firstTeam = firstTeamIt.next();
                Map<Day, Match> firstTeamDayMap = this.teamDayMap.get(firstTeam);
                ListIterator<Team> secondTeamIt = this.teamList.listIterator(firstTeamIt.nextIndex());
                block1: while (secondTeamIt.hasNext()) {
                    Team secondTeam = secondTeamIt.next();
                    ArrayList<Match> clonedFirstTeamMatchList = new ArrayList<Match>(firstTeamDayMap.values());
                    while (!clonedFirstTeamMatchList.isEmpty()) {
                        ArrayList<Match> firstRotateList = new ArrayList<Match>();
                        ArrayList<Match> secondRotateList = new ArrayList<Match>();
                        Match firstStartMatch = (Match)clonedFirstTeamMatchList.remove(0);
                        Team firstStartTeam = this.getOtherTeam(firstStartMatch, firstTeam);
                        Day startDay = firstStartMatch.getDay();
                        boolean firstTeamIsHomeTeam = firstStartMatch.getHomeTeam().equals(firstTeam);
                        Match secondStartMatch = this.teamDayMap.get(secondTeam).get(startDay);
                        if (firstStartMatch.equals(secondStartMatch)) continue block1;
                        firstRotateList.add(0, firstStartMatch);
                        secondRotateList.add(secondStartMatch);
                        HashMap<Team, Match> visitedTeamMap = new HashMap<Team, Match>();
                        Team teamToFind = this.getOtherTeam(secondStartMatch, secondTeam);
                        while (!teamToFind.equals(firstStartTeam)) {
                            Match firstRepairMatch = this.homeTeamAwayTeamMap.get(firstTeamIsHomeTeam ? firstTeam : teamToFind).get(firstTeamIsHomeTeam ? teamToFind : firstTeam);
                            if (!clonedFirstTeamMatchList.contains(firstRepairMatch)) {
                                if (visitedTeamMap.containsKey(teamToFind)) {
                                    Match shortcutMatch = (Match)visitedTeamMap.get(teamToFind);
                                    int shortcutSize = firstRotateList.indexOf(shortcutMatch) + 1;
                                    int reverseShortcutSize = firstRotateList.size() - shortcutSize;
                                    ArrayList<Match> firstShortcutRotateList = new ArrayList<Match>(firstRotateList.subList(0, shortcutSize));
                                    for (Match match : firstShortcutRotateList) {
                                        visitedTeamMap.remove(this.getOtherTeam(match, firstTeam));
                                    }
                                    ArrayList<Match> secondShortcutRotateList = new ArrayList<Match>(secondRotateList.subList(reverseShortcutSize, secondRotateList.size()));
                                    firstRotateList = new ArrayList(firstRotateList.subList(shortcutSize, firstRotateList.size()));
                                    secondRotateList = new ArrayList(secondRotateList.subList(0, reverseShortcutSize));
                                    this.addTeamRotateMove(moveList, firstShortcutRotateList, secondShortcutRotateList);
                                }
                                firstTeamIsHomeTeam = !firstTeamIsHomeTeam;
                                firstRepairMatch = this.homeTeamAwayTeamMap.get(firstTeamIsHomeTeam ? firstTeam : teamToFind).get(firstTeamIsHomeTeam ? teamToFind : firstTeam);
                            }
                            Day repairDay = firstRepairMatch.getDay();
                            Match secondRepairMatch = this.teamDayMap.get(secondTeam).get(repairDay);
                            clonedFirstTeamMatchList.remove(firstRepairMatch);
                            visitedTeamMap.put(teamToFind, firstRepairMatch);
                            firstRotateList.add(0, firstRepairMatch);
                            secondRotateList.add(secondRepairMatch);
                            teamToFind = this.getOtherTeam(secondRepairMatch, secondTeam);
                        }
                        this.addTeamRotateMove(moveList, firstRotateList, secondRotateList);
                    }
                }
            }
        }

        private void addTeamRotateMove(List<Move> moveList, List<Match> firstRotateList, List<Match> secondRotateList) {
            assert (firstRotateList.size() == secondRotateList.size());
            if (firstRotateList.size() > 2) {
                MatchChainRotationsMove rotateMove = new MatchChainRotationsMove(firstRotateList, secondRotateList);
                moveList.add(rotateMove);
            }
        }
    }
}

