/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.cheaptime.persistence.CheapTimeDao;
import org.optaplanner.examples.cheaptime.persistence.CheapTimeExporter;
import org.optaplanner.examples.cheaptime.persistence.CheapTimeImporter;
import org.optaplanner.examples.cheaptime.swingui.CheapTimePanel;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;

public class CheapTimeApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/cheaptime/solver/cheapTimeSolverConfig.xml";

    public static void main(String[] args) {
        CheapTimeApp.prepareSwingEnvironment();
        new CheapTimeApp().init();
    }

    public CheapTimeApp() {
        super("Cheap power time scheduling", "Assign tasks to machines and time.\n\nEach machine must have enough hardware to run all of its tasks.\nEach task inflicts a power cost. Power costs differ over time.", null);
    }

    @Override
    protected Solver createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new CheapTimePanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new CheapTimeDao();
    }

    @Override
    protected AbstractSolutionImporter createSolutionImporter() {
        return new CheapTimeImporter();
    }

    @Override
    protected AbstractSolutionExporter createSolutionExporter() {
        return new CheapTimeExporter();
    }
}

