/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui.latitudelongitude;

public class LatitudeLongitudeTranslator {
    public static final double MARGIN_RATIO = 0.04;
    private double minimumLatitude = Double.MAX_VALUE;
    private double maximumLatitude = -1.7976931348623157E308;
    private double minimumLongitude = Double.MAX_VALUE;
    private double maximumLongitude = -1.7976931348623157E308;
    private double latitudeLength = 0.0;
    private double longitudeLength = 0.0;
    private double innerWidth = 0.0;
    private double innerHeight = 0.0;
    private double innerWidthMargin = 0.0;
    private double innerHeightMargin = 0.0;
    private int imageWidth = -1;
    private int imageHeight = -1;

    public void addCoordinates(double latitude, double longitude) {
        if (latitude < this.minimumLatitude) {
            this.minimumLatitude = latitude;
        }
        if (latitude > this.maximumLatitude) {
            this.maximumLatitude = latitude;
        }
        if (longitude < this.minimumLongitude) {
            this.minimumLongitude = longitude;
        }
        if (longitude > this.maximumLongitude) {
            this.maximumLongitude = longitude;
        }
    }

    public void prepareFor(double width, double height) {
        this.latitudeLength = this.maximumLatitude - this.minimumLatitude;
        this.longitudeLength = this.maximumLongitude - this.minimumLongitude;
        this.innerWidthMargin = width * 0.04;
        this.innerHeightMargin = height * 0.04;
        this.innerWidth = width - 2.0 * this.innerWidthMargin;
        this.innerHeight = height - 2.0 * this.innerHeightMargin;
        if (this.innerWidth > this.innerHeight * this.longitudeLength / this.latitudeLength) {
            this.innerWidth = this.innerHeight * this.longitudeLength / this.latitudeLength;
        } else {
            this.innerHeight = this.innerWidth * this.latitudeLength / this.longitudeLength;
        }
        this.imageWidth = (int)Math.floor(2.0 * this.innerWidthMargin + this.innerWidth);
        this.imageHeight = (int)Math.floor(2.0 * this.innerHeightMargin + this.innerHeight);
    }

    public int translateLongitudeToX(double longitude) {
        return (int)Math.floor((longitude - this.minimumLongitude) * this.innerWidth / this.longitudeLength + this.innerWidthMargin);
    }

    public int translateLatitudeToY(double latitude) {
        return (int)Math.floor((this.maximumLatitude - latitude) * this.innerHeight / this.latitudeLength + this.innerHeightMargin);
    }

    public double translateXToLongitude(int x) {
        return this.minimumLongitude + ((double)x - this.innerWidthMargin) * this.longitudeLength / this.innerWidth;
    }

    public double translateYToLatitude(double y) {
        return this.maximumLatitude - (y - this.innerHeightMargin) * this.latitudeLength / this.innerHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }
}

