/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.swingui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.ohlc.OHLCSeries;
import org.jfree.data.time.ohlc.OHLCSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.util.ShapeUtilities;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.PeriodPowerPrice;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.common.swingui.SolutionPanel;

public class CheapTimePanel
extends SolutionPanel {
    private PlotTaskAssignmentComparator plotTaskAssignmentComparator = new PlotTaskAssignmentComparator();
    public static final String LOGO_PATH = "/org/optaplanner/examples/cheaptime/swingui/cheapTimeLogo.png";

    public CheapTimePanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    private CheapTimeSolution getCheapTimeSolution() {
        return (CheapTimeSolution)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        this.removeAll();
        ChartPanel chartPanel = new ChartPanel(this.createChart((CheapTimeSolution)solution));
        this.add((Component)chartPanel, "Center");
    }

    private JFreeChart createChart(CheapTimeSolution solution) {
        NumberAxis rangeAxis = new NumberAxis("Period");
        rangeAxis.setRange(-0.5, (double)solution.getGlobalPeriodRangeTo() + 0.5);
        XYPlot taskAssignmentPlot = this.createTaskAssignmentPlot(solution);
        XYPlot periodCostPlot = this.createPeriodCostPlot(solution);
        CombinedRangeXYPlot combinedPlot = new CombinedRangeXYPlot((ValueAxis)rangeAxis);
        combinedPlot.add(taskAssignmentPlot, 5);
        combinedPlot.add(periodCostPlot, 1);
        combinedPlot.setOrientation(PlotOrientation.HORIZONTAL);
        return new JFreeChart("Cheap Power Time Scheduling", JFreeChart.DEFAULT_TITLE_FONT, (Plot)combinedPlot, true);
    }

    private XYPlot createTaskAssignmentPlot(CheapTimeSolution solution) {
        OHLCSeriesCollection seriesCollection = new OHLCSeriesCollection();
        LinkedHashMap<Machine, OHLCSeries> machineSeriesMap = new LinkedHashMap<Machine, OHLCSeries>(solution.getMachineList().size());
        HighLowRenderer renderer = new HighLowRenderer();
        renderer.setTickLength(0.0);
        int seriesIndex = 0;
        OHLCSeries unassignedProjectSeries = new OHLCSeries((Comparable)((Object)"Unassigned"));
        seriesCollection.addSeries(unassignedProjectSeries);
        machineSeriesMap.put(null, unassignedProjectSeries);
        renderer.setSeriesStroke(seriesIndex, (Stroke)new BasicStroke(3.0f));
        ++seriesIndex;
        for (Machine machine : solution.getMachineList()) {
            OHLCSeries projectSeries = new OHLCSeries((Comparable)((Object)machine.getLabel()));
            seriesCollection.addSeries(projectSeries);
            machineSeriesMap.put(machine, projectSeries);
            renderer.setSeriesStroke(seriesIndex, (Stroke)new BasicStroke(3.0f));
            ++seriesIndex;
        }
        ArrayList<TaskAssignment> taskAssignmentList = new ArrayList<TaskAssignment>(solution.getTaskAssignmentList());
        Collections.sort(taskAssignmentList, this.plotTaskAssignmentComparator);
        int pixelIndex = 0;
        for (TaskAssignment taskAssignment : taskAssignmentList) {
            Integer startPeriod = taskAssignment.getStartPeriod();
            Integer endPeriod = taskAssignment.getEndPeriod();
            if (startPeriod == null) {
                startPeriod = 0;
                endPeriod = 0;
            }
            OHLCSeries machineSeries = (OHLCSeries)machineSeriesMap.get(taskAssignment.getMachine());
            Task task = taskAssignment.getTask();
            machineSeries.add((RegularTimePeriod)new FixedMillisecond((long)pixelIndex), (double)task.getStartPeriodRangeFrom(), (double)startPeriod.intValue(), (double)endPeriod.intValue(), (double)(task.getStartPeriodRangeTo() + task.getDuration()));
            ++pixelIndex;
        }
        NumberAxis domainAxis = new NumberAxis("Task");
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domainAxis.setRange(-0.5, (double)taskAssignmentList.size() - 0.5);
        domainAxis.setInverted(true);
        return new XYPlot((XYDataset)seriesCollection, (ValueAxis)domainAxis, null, (XYItemRenderer)renderer);
    }

    private XYPlot createPeriodCostPlot(CheapTimeSolution solution) {
        XYSeries series = new XYSeries((Comparable)((Object)"Power price"));
        for (PeriodPowerPrice periodPowerPrice : solution.getPeriodPowerPriceList()) {
            series.add((double)periodPowerPrice.getPowerPriceMicros() / 1000000.0, (double)periodPowerPrice.getPeriod());
        }
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        seriesCollection.addSeries(series);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1);
        renderer.setSeriesShape(0, ShapeUtilities.createDiamond((float)2.0f));
        NumberAxis domainAxis = new NumberAxis("Power price");
        return new XYPlot((XYDataset)seriesCollection, (ValueAxis)domainAxis, null, (XYItemRenderer)renderer);
    }

    private static class PlotTaskAssignmentComparator
    implements Comparator<TaskAssignment> {
        private PlotTaskAssignmentComparator() {
        }

        @Override
        public int compare(TaskAssignment a, TaskAssignment b) {
            Machine aMachine = a.getMachine();
            Machine bMachine = b.getMachine();
            return new CompareToBuilder().append((Object)(aMachine == null ? null : aMachine.getId()), (Object)(bMachine == null ? null : bMachine.getId())).append((Object)a.getStartPeriod(), (Object)b.getStartPeriod()).append(a.getTask().getDuration(), b.getTask().getDuration()).append((Object)a.getId(), (Object)b.getId()).toComparison();
        }
    }
}

