/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionDao;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public abstract class XStreamSolutionDao
extends AbstractSolutionDao {
    protected XStreamSolutionFileIO xStreamSolutionFileIO;

    public XStreamSolutionDao(String dirName, Class ... xStreamAnnotations) {
        super(dirName);
        this.xStreamSolutionFileIO = new XStreamSolutionFileIO(xStreamAnnotations);
    }

    @Override
    public String getFileExtension() {
        return this.xStreamSolutionFileIO.getOutputFileExtension();
    }

    @Override
    public Solution readSolution(File inputSolutionFile) {
        Solution solution = this.xStreamSolutionFileIO.read(inputSolutionFile);
        this.logger.info("Opened: {}", (Object)inputSolutionFile);
        return solution;
    }

    @Override
    public void writeSolution(Solution solution, File outputSolutionFile) {
        this.xStreamSolutionFileIO.write(solution, outputSolutionFile);
        this.logger.info("Saved: {}", (Object)outputSolutionFile);
    }
}

