/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolutionDao
implements SolutionDao {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String dirName;
    protected File dataDir;

    public AbstractSolutionDao(String dirName) {
        this.dirName = dirName;
        this.dataDir = new File("data/" + dirName);
        if (!this.dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + this.dataDir.getAbsolutePath() + ") does not exist.\n" + " The working directory should be set to the directory that contains the data directory" + " (which is not the data directory itself).\n" + " The working directory is different in a git clone (optaplanner/optaplanner-examples)" + " and the release zip (examples).\n" + " In an IDE (IntelliJ, Eclipse, NetBeans), open the \"Run configuration\"" + " to change the field \"Working directory\".");
        }
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }
}

