/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class SolutionDaoTest
extends LoggingTest {
    protected SolutionDao solutionDao;
    protected File solutionFile;

    protected static Collection<Object[]> getSolutionFilesAsParameters(SolutionDao solutionDao) {
        ArrayList fileList = new ArrayList(0);
        File dataDir = solutionDao.getDataDir();
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        fileList.addAll(FileUtils.listFiles((File)unsolvedDataDir, (String[])new String[]{solutionDao.getFileExtension()}, (boolean)true));
        File solvedDataDir = new File(dataDir, "solved");
        if (solvedDataDir.exists()) {
            fileList.addAll(FileUtils.listFiles((File)solvedDataDir, (String[])new String[]{solutionDao.getFileExtension()}, (boolean)true));
        }
        Collections.sort(fileList, new ProblemFileComparator());
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected SolutionDaoTest(File solutionFile) {
        this.solutionFile = solutionFile;
    }

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
    }

    protected abstract SolutionDao createSolutionDao();

    @Test
    public void readSolution() {
        this.solutionDao.readSolution(this.solutionFile);
    }
}

