/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.domain.solver.LatitudeVisitDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=LatitudeVisitDifficultyComparator.class)
@XStreamAlias(value="Visit")
public class Visit
extends AbstractPersistable
implements Standstill {
    private Location location;
    private Standstill previousStandstill;

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @PlanningVariable(valueRangeProviderRefs={"domicileRange", "visitRange"}, graphType=PlanningVariableGraphType.CHAINED)
    public Standstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(Standstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    public long getDistanceFromPreviousStandstill() {
        if (this.previousStandstill == null) {
            return 0L;
        }
        return this.getDistanceTo(this.previousStandstill);
    }

    @Override
    public long getDistanceTo(Standstill standstill) {
        return this.location.getDistance(standstill.getLocation());
    }

    @Override
    public String toString() {
        return this.location + "(after " + (this.previousStandstill == null ? "null" : this.previousStandstill.getLocation()) + ")";
    }
}

