/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingDao;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingImporter;
import org.optaplanner.examples.vehiclerouting.swingui.VehicleRoutingPanel;

public class VehicleRoutingApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml";

    public static void main(String[] args) {
        VehicleRoutingApp.prepareSwingEnvironment();
        new VehicleRoutingApp().init();
    }

    public VehicleRoutingApp() {
        super("Vehicle routing", "Official competition name: Capacitated vehicle routing problem (CVRP), optionally with time windows (CVRPTW)\n\nPick up all items of all customers with a few vehicles.\n\nFind the shortest route possible.\nDo not overload the capacity of the vehicles.\nArrive within the time window of each customer.", "/org/optaplanner/examples/vehiclerouting/swingui/vehicleRoutingLogo.png");
    }

    @Override
    protected Solver createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new VehicleRoutingPanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new VehicleRoutingDao();
    }

    @Override
    protected AbstractSolutionImporter createSolutionImporter() {
        return new VehicleRoutingImporter();
    }
}

