/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import com.google.common.math.BigIntegerMath;
import java.io.File;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractSolutionImporter
extends LoggingMain {
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = "xml";
    protected final SolutionDao solutionDao;
    protected final File inputDir;
    protected final File outputDir;

    public AbstractSolutionImporter(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
        this.inputDir = new File(solutionDao.getDataDir(), "import");
        if (!this.inputDir.exists()) {
            throw new IllegalStateException("The directory inputDir (" + this.inputDir.getAbsolutePath() + ") does not exist.");
        }
        this.outputDir = new File(solutionDao.getDataDir(), "unsolved");
    }

    public AbstractSolutionImporter(boolean withoutDao) {
        if (!withoutDao) {
            throw new IllegalArgumentException("The parameter withoutDao (" + withoutDao + ") must be true.");
        }
        this.solutionDao = null;
        this.inputDir = null;
        this.outputDir = null;
    }

    public File getInputDir() {
        return this.inputDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public boolean isInputFileDirectory() {
        return false;
    }

    public abstract String getInputFileSuffix();

    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public void convertAll() {
        File[] inputFiles = this.inputDir.listFiles();
        Arrays.sort(inputFiles, new ProblemFileComparator());
        for (File inputFile : inputFiles) {
            if (!this.acceptInputFile(inputFile) || !this.acceptInputFileDuringBulkConvert(inputFile)) continue;
            String inputFileName = inputFile.getName();
            String outputFileName = inputFileName.substring(0, inputFileName.length() - this.getInputFileSuffix().length()) + this.getOutputFileSuffix();
            File outputFile = new File(this.outputDir, outputFileName);
            this.convert(inputFile, outputFile);
        }
    }

    public void convert(String inputFileName, String outputFileName) {
        File inputFile = new File(this.inputDir, inputFileName);
        if (!inputFile.exists()) {
            throw new IllegalStateException("The file inputFile (" + inputFile.getAbsolutePath() + ") does not exist.");
        }
        File outputFile = new File(this.outputDir, outputFileName);
        outputFile.getParentFile().mkdirs();
        this.convert(inputFile, outputFile);
    }

    protected void convert(File inputFile, File outputFile) {
        Solution solution = this.readSolution(inputFile);
        this.solutionDao.writeSolution(solution, outputFile);
    }

    public boolean acceptInputFile(File inputFile) {
        return inputFile.getName().endsWith("." + this.getInputFileSuffix());
    }

    public boolean acceptInputFileDuringBulkConvert(File inputFile) {
        return true;
    }

    public abstract Solution readSolution(File var1);

    public static String getFlooredPossibleSolutionSize(BigInteger possibleSolutionSize) {
        if (possibleSolutionSize.compareTo(BigInteger.valueOf(1000L)) < 0) {
            return possibleSolutionSize.toString();
        }
        return "10^" + BigIntegerMath.log10((BigInteger)possibleSolutionSize, (RoundingMode)RoundingMode.FLOOR);
    }

    public static abstract class InputBuilder
    extends LoggingMain {
    }
}

