/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investmentallocation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.investmentallocation.domain.util.InvestmentAllocationNumericUtil;

@XStreamAlias(value="AssetClass")
public class AssetClass
extends AbstractPersistable {
    private String name;
    private long expectedReturnMillis;
    private long standardDeviationRiskMillis;
    private Map<AssetClass, Long> correlationMillisMap;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getExpectedReturnMillis() {
        return this.expectedReturnMillis;
    }

    public void setExpectedReturnMillis(long expectedReturnMillis) {
        this.expectedReturnMillis = expectedReturnMillis;
    }

    public long getStandardDeviationRiskMillis() {
        return this.standardDeviationRiskMillis;
    }

    public void setStandardDeviationRiskMillis(long standardDeviationRiskMillis) {
        this.standardDeviationRiskMillis = standardDeviationRiskMillis;
    }

    public Map<AssetClass, Long> getCorrelationMillisMap() {
        return this.correlationMillisMap;
    }

    public void setCorrelationMillisMap(Map<AssetClass, Long> correlationMillisMap) {
        this.correlationMillisMap = correlationMillisMap;
    }

    public String getExpectedReturnLabel() {
        return InvestmentAllocationNumericUtil.formatMillisAsPercentage(this.expectedReturnMillis);
    }

    public String getStandardDeviationRiskLabel() {
        return InvestmentAllocationNumericUtil.formatMillisAsPercentage(this.standardDeviationRiskMillis);
    }

    public String getCorrelationLabel(AssetClass other) {
        long correlationMillis = this.correlationMillisMap.get(other);
        return InvestmentAllocationNumericUtil.formatMillisAsNumber(correlationMillis);
    }

    @Override
    public String toString() {
        return this.id + "-" + this.name;
    }
}

