/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investmentallocation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.investmentallocation.domain.AssetClass;
import org.optaplanner.examples.investmentallocation.domain.AssetClassAllocation;
import org.optaplanner.examples.investmentallocation.domain.InvestmentParametrization;
import org.optaplanner.persistence.xstream.impl.score.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="InvestmentAllocationSolution")
public class InvestmentAllocationSolution
extends AbstractPersistable
implements Solution<HardSoftLongScore> {
    private InvestmentParametrization parametrization;
    private List<AssetClass> assetClassList;
    private List<AssetClassAllocation> assetClassAllocationList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftLongScoreDefinition.class})
    private HardSoftLongScore score;

    public InvestmentParametrization getParametrization() {
        return this.parametrization;
    }

    public void setParametrization(InvestmentParametrization parametrization) {
        this.parametrization = parametrization;
    }

    public List<AssetClass> getAssetClassList() {
        return this.assetClassList;
    }

    public void setAssetClassList(List<AssetClass> assetClassList) {
        this.assetClassList = assetClassList;
    }

    @PlanningEntityCollectionProperty
    public List<AssetClassAllocation> getAssetClassAllocationList() {
        return this.assetClassAllocationList;
    }

    public void setAssetClassAllocationList(List<AssetClassAllocation> assetClassAllocationList) {
        this.assetClassAllocationList = assetClassAllocationList;
    }

    public HardSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftLongScore score) {
        this.score = score;
    }

    @ValueRangeProvider(id="quantityMillisRange")
    public CountableValueRange<Long> getQuantityMillisRange() {
        return ValueRangeFactory.createLongValueRange((long)0L, (long)1001L);
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.add(this.parametrization);
        facts.addAll(this.assetClassList);
        return facts;
    }

    public long calculateExpectedReturnMicros() {
        long expectedReturnMicros = 0L;
        for (AssetClassAllocation allocation : this.assetClassAllocationList) {
            expectedReturnMicros += allocation.getQuantifiedExpectedReturnMicros();
        }
        return expectedReturnMicros;
    }

    public long calculateStandardDeviationMicros() {
        long squaredFemtos = this.calculateStandardDeviationSquaredFemtos();
        return (long)Math.sqrt(squaredFemtos / 1000L);
    }

    public long calculateStandardDeviationSquaredFemtos() {
        long totalFemtos = 0L;
        for (AssetClassAllocation a : this.assetClassAllocationList) {
            for (AssetClassAllocation b : this.assetClassAllocationList) {
                if (a == b) {
                    totalFemtos += a.getQuantifiedStandardDeviationRiskMicros() * b.getQuantifiedStandardDeviationRiskMicros() * 1000L;
                    continue;
                }
                long correlationMillis = a.getAssetClass().getCorrelationMillisMap().get(b.getAssetClass());
                totalFemtos += a.getQuantifiedStandardDeviationRiskMicros() * b.getQuantifiedStandardDeviationRiskMicros() * correlationMillis;
            }
        }
        return totalFemtos;
    }
}

