/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investmentallocation.persistence;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.investmentallocation.domain.AssetClass;
import org.optaplanner.examples.investmentallocation.domain.AssetClassAllocation;
import org.optaplanner.examples.investmentallocation.domain.InvestmentAllocationSolution;
import org.optaplanner.examples.investmentallocation.domain.InvestmentParametrization;
import org.optaplanner.examples.investmentallocation.persistence.InvestmentAllocationDao;

public class InvestmentAllocationImporter
extends AbstractTxtSolutionImporter {
    private static final String INPUT_FILE_SUFFIX = "csv";

    public static void main(String[] args) {
        InvestmentAllocationImporter importer = new InvestmentAllocationImporter();
        importer.convert("irrinki_1.csv", "irrinki_1.xml");
    }

    public InvestmentAllocationImporter() {
        super(new InvestmentAllocationDao());
    }

    public InvestmentAllocationImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new InvestmentAllocationInputBuilder();
    }

    public static class InvestmentAllocationInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private InvestmentAllocationSolution solution;

        @Override
        public Solution readSolution() throws IOException {
            this.solution = new InvestmentAllocationSolution();
            this.solution.setId(0L);
            this.readHeaders();
            this.readAssetClassList();
            this.createAssetClassAllocationList();
            this.logger.info("InvestmentAllocation {} has {} asset classes.", (Object)this.getInputId(), (Object)this.solution.getAssetClassList().size());
            return this.solution;
        }

        private void readHeaders() throws IOException {
            this.readConstantLine("ABC Institutional Investor Capital Markets Expectations;*");
            this.readConstantLine("Asset class;+Correlation;*");
            InvestmentParametrization parametrization = new InvestmentParametrization();
            parametrization.setId(0L);
            parametrization.setStandardDeviationMillisMaximum(95L);
            this.solution.setParametrization(parametrization);
        }

        private void readAssetClassList() throws IOException {
            String headerLine = this.bufferedReader.readLine();
            String[] headerTokens = this.splitBySemicolonSeparatedValue(headerLine);
            String headerRegex = "ID;Name;Expected return;Standard deviation(;\\d+)+";
            if (!headerLine.trim().matches(headerRegex)) {
                throw new IllegalArgumentException("Read line (" + headerLine + ") is expected to be a constant regex (" + headerRegex + ").");
            }
            int ASSET_CLASS_PROPERTIES_COUNT = 4;
            int assetClassListSize = headerTokens.length - 4;
            ArrayList<AssetClass> assetClassList = new ArrayList<AssetClass>(assetClassListSize);
            HashMap<Long, AssetClass> idToAssetClassMap = new HashMap<Long, AssetClass>(assetClassListSize);
            for (int i = 0; i < assetClassListSize; ++i) {
                AssetClass assetClass = new AssetClass();
                assetClass.setId(Long.parseLong(headerTokens[4 + i]));
                assetClassList.add(assetClass);
                idToAssetClassMap.put(assetClass.getId(), assetClass);
            }
            String line = this.bufferedReader.readLine();
            while (line != null) {
                String[] tokens = this.splitBySemicolonSeparatedValue(line, 4 + assetClassListSize);
                long id = Long.parseLong(tokens[0]);
                AssetClass assetClass = (AssetClass)idToAssetClassMap.get(id);
                if (assetClass == null) {
                    throw new IllegalStateException("The assetClass line (" + line + ") has an assetClass id (" + id + ") that is not in the headerLine (" + headerLine + ")");
                }
                assetClass.setName(tokens[1]);
                assetClass.setExpectedReturnMillis(this.parsePercentageMillis(tokens[2]));
                assetClass.setStandardDeviationRiskMillis(this.parsePercentageMillis(tokens[3]));
                LinkedHashMap<AssetClass, Long> correlationMillisMap = new LinkedHashMap<AssetClass, Long>(assetClassListSize);
                for (int i = 0; i < assetClassListSize; ++i) {
                    AssetClass other = (AssetClass)assetClassList.get(i);
                    long correlationMillis = this.parsePercentageMillis(tokens[4 + i]);
                    correlationMillisMap.put(other, correlationMillis);
                }
                assetClass.setCorrelationMillisMap(correlationMillisMap);
                line = this.bufferedReader.readLine();
            }
            this.solution.setAssetClassList(assetClassList);
        }

        private void createAssetClassAllocationList() {
            List<AssetClass> assetClassList = this.solution.getAssetClassList();
            ArrayList<AssetClassAllocation> assetClassAllocationList = new ArrayList<AssetClassAllocation>(assetClassList.size());
            for (AssetClass assetClass : assetClassList) {
                AssetClassAllocation allocation = new AssetClassAllocation();
                allocation.setId(assetClass.getId());
                allocation.setAssetClass(assetClass);
                assetClassAllocationList.add(allocation);
            }
            this.solution.setAssetClassAllocationList(assetClassAllocationList);
        }

        protected long parsePercentageMillis(String token) {
            BigDecimal millis = token.endsWith("%") ? new BigDecimal(token.substring(0, token.length() - 1)).multiply(new BigDecimal(10L)) : new BigDecimal(token).multiply(new BigDecimal(1000L));
            return millis.longValueExact();
        }
    }
}

