/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investmentallocation.solver.move.factory;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.random.RandomUtils;
import org.optaplanner.examples.investmentallocation.domain.AssetClassAllocation;
import org.optaplanner.examples.investmentallocation.domain.InvestmentAllocationSolution;
import org.optaplanner.examples.investmentallocation.solver.move.InvestmentQuantityTransferMove;

public class InvestmentQuantityTransferMoveIteratorFactory
implements MoveIteratorFactory {
    public long getSize(ScoreDirector scoreDirector) {
        InvestmentAllocationSolution solution = (InvestmentAllocationSolution)scoreDirector.getWorkingSolution();
        return (long)(solution.getAssetClassAllocationList().size() - 1) * 1000L;
    }

    public Iterator<Move> createOriginalMoveIterator(ScoreDirector scoreDirector) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Move> createRandomMoveIterator(ScoreDirector scoreDirector, Random workingRandom) {
        InvestmentAllocationSolution solution = (InvestmentAllocationSolution)scoreDirector.getWorkingSolution();
        List<AssetClassAllocation> allocationList = solution.getAssetClassAllocationList();
        TreeMap<Long, AssetClassAllocation> quantityMillisIncrementToAllocationMap = new TreeMap<Long, AssetClassAllocation>();
        long quantityIncrementMillis = 0L;
        for (AssetClassAllocation allocation : allocationList) {
            long quantityMillis = allocation.getQuantityMillis();
            if (quantityMillis <= 0L) continue;
            quantityMillisIncrementToAllocationMap.put(quantityIncrementMillis += quantityMillis, allocation);
        }
        if (quantityIncrementMillis != 1000L) {
            throw new IllegalStateException("The quantityIncrementMillis (" + quantityIncrementMillis + ") must always be total to MAXIMUM_QUANTITY_MILLIS (" + 1000L + ").");
        }
        return new RandomInvestmentQuantityTransferMoveIterator(allocationList, quantityMillisIncrementToAllocationMap, workingRandom);
    }

    private class RandomInvestmentQuantityTransferMoveIterator
    implements Iterator<Move> {
        private final List<AssetClassAllocation> allocationList;
        private final NavigableMap<Long, AssetClassAllocation> quantityMillisIncrementToAllocationMap;
        private final Random workingRandom;

        public RandomInvestmentQuantityTransferMoveIterator(List<AssetClassAllocation> allocationList, NavigableMap<Long, AssetClassAllocation> quantityMillisIncrementToAllocationMap, Random workingRandom) {
            this.allocationList = allocationList;
            this.quantityMillisIncrementToAllocationMap = quantityMillisIncrementToAllocationMap;
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return this.allocationList.size() > 1;
        }

        @Override
        public Move next() {
            long transferMillis = RandomUtils.nextLong((Random)this.workingRandom, (long)1000L) + 1L;
            Map.Entry<Long, AssetClassAllocation> lowerEntry = this.quantityMillisIncrementToAllocationMap.lowerEntry(transferMillis);
            Map.Entry<Long, AssetClassAllocation> ceilingEntry = this.quantityMillisIncrementToAllocationMap.ceilingEntry(transferMillis);
            transferMillis -= lowerEntry == null ? 0L : lowerEntry.getKey();
            AssetClassAllocation fromAllocation = ceilingEntry.getValue();
            int fromAllocationIndex = this.allocationList.indexOf(fromAllocation);
            int toAllocationIndex = this.workingRandom.nextInt(this.allocationList.size() - 1);
            if (toAllocationIndex >= fromAllocationIndex) {
                ++toAllocationIndex;
            }
            AssetClassAllocation toAllocation = this.allocationList.get(toAllocationIndex);
            return new InvestmentQuantityTransferMove(fromAllocation, toAllocation, transferMillis);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The optional operation remove() is not supported.");
        }
    }
}

