/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.solver;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;

public class DepotAngleCustomerDifficultyWeightFactory
implements SelectionSorterWeightFactory<VehicleRoutingSolution, Customer> {
    public Comparable createSorterWeight(VehicleRoutingSolution vehicleRoutingSolution, Customer customer) {
        Depot depot = vehicleRoutingSolution.getDepotList().get(0);
        return new DepotAngleCustomerDifficultyWeight(customer, customer.getLocation().getAngle(depot.getLocation()), customer.getLocation().getDistanceTo(depot.getLocation()) + depot.getLocation().getDistanceTo(customer.getLocation()));
    }

    public static class DepotAngleCustomerDifficultyWeight
    implements Comparable<DepotAngleCustomerDifficultyWeight> {
        private final Customer customer;
        private final double depotAngle;
        private final int depotRoundTripDistance;

        public DepotAngleCustomerDifficultyWeight(Customer customer, double depotAngle, int depotRoundTripDistance) {
            this.customer = customer;
            this.depotAngle = depotAngle;
            this.depotRoundTripDistance = depotRoundTripDistance;
        }

        @Override
        public int compareTo(DepotAngleCustomerDifficultyWeight other) {
            return new CompareToBuilder().append(this.depotAngle, other.depotAngle).append(this.depotRoundTripDistance, other.depotRoundTripDistance).append((Object)this.customer.getId(), (Object)other.customer.getId()).toComparison();
        }
    }
}

