/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.persistence.TspImporter;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingDao;

public class VehicleRoutingTspBasedGenerator
extends LoggingMain {
    protected final TspImporter tspImporter = new TspImporter();
    protected final VehicleRoutingDao vehicleRoutingDao = new VehicleRoutingDao();

    public static void main(String[] args) {
        new VehicleRoutingTspBasedGenerator().generate();
    }

    public void generate() {
        this.generateVrp(new File(this.tspImporter.getInputDir(), "usa115475.tsp"), 100, 10, 250);
        this.generateVrp(new File(this.tspImporter.getInputDir(), "usa115475.tsp"), 500, 20, 250);
        this.generateVrp(new File(this.tspImporter.getInputDir(), "usa115475.tsp"), 1000, 20, 500);
        this.generateVrp(new File(this.tspImporter.getInputDir(), "usa115475.tsp"), 5000, 100, 500);
        this.generateVrp(new File(this.tspImporter.getInputDir(), "usa115475.tsp"), 10000, 100, 1000);
        this.generateVrp(new File(this.tspImporter.getInputDir(), "usa115475.tsp"), 50000, 500, 1000);
        this.generateVrp(new File(this.tspImporter.getInputDir(), "usa115475.tsp"), 100000, 500, 2000);
    }

    public void generateVrp(File tspInputFile, int locationListSize, int vehicleListSize, int capacity) {
        TravelingSalesmanTour tour = (TravelingSalesmanTour)this.tspImporter.readSolution(tspInputFile);
        String name = tspInputFile.getName().replaceAll("\\d+\\.tsp", "") + "-n" + locationListSize + "-k" + vehicleListSize;
        File vrpOutputFile = new File(this.vehicleRoutingDao.getDataDir(), "import/capacitated/" + name + ".vrp");
        if (!vrpOutputFile.getParentFile().exists()) {
            throw new IllegalArgumentException("The vrpOutputFile parent directory (" + vrpOutputFile.getParentFile() + ") does not exist.");
        }
        BufferedWriter vrpWriter = null;
        try {
            vrpWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(vrpOutputFile), "UTF-8"));
            vrpWriter.write("NAME: " + name + "\n");
            vrpWriter.write("COMMENT: Generated from " + tspInputFile.getName() + "\n");
            vrpWriter.write("TYPE: CVRP\n");
            vrpWriter.write("DIMENSION: " + locationListSize + "\n");
            vrpWriter.write("EDGE_WEIGHT_TYPE: EUC_2D\n");
            vrpWriter.write("CAPACITY: " + capacity + "\n");
            vrpWriter.write("NODE_COORD_SECTION\n");
            List<org.optaplanner.examples.tsp.domain.location.Location> tspLocationList = tour.getLocationList();
            double selectionDecrement = (double)locationListSize / (double)tspLocationList.size();
            double selection = locationListSize;
            int index = 1;
            for (org.optaplanner.examples.tsp.domain.location.Location tspLocation : tspLocationList) {
                double newSelection = selection - selectionDecrement;
                if ((int)newSelection < (int)selection) {
                    vrpWriter.write(index + " " + tspLocation.getLatitude() + " " + tspLocation.getLongitude() + "\n");
                    ++index;
                }
                selection = newSelection;
            }
            vrpWriter.write("DEMAND_SECTION\n");
            int maximumDemand = 4 * vehicleListSize * capacity / (locationListSize * 3);
            Random random = new Random(37L);
            vrpWriter.write("1 0\n");
            for (int i = 2; i <= locationListSize; ++i) {
                vrpWriter.write(i + " " + (random.nextInt(maximumDemand) + 1) + "\n");
            }
            vrpWriter.write("DEPOT_SECTION\n");
            vrpWriter.write("1\n");
            vrpWriter.write("-1\n");
            vrpWriter.write("EOF\n");
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not read the tspInputFile (" + tspInputFile.getName() + ") or write the vrpOutputFile (" + vrpOutputFile.getName() + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(vrpWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)vrpWriter);
        this.logger.info("Generated: {}", (Object)vrpOutputFile);
    }

    public static VehicleRoutingSolution convert(TravelingSalesmanTour tour) {
        Customer customer;
        VehicleRoutingSolution vehicleRoutingSolution = new VehicleRoutingSolution();
        vehicleRoutingSolution.setName(tour.getName());
        vehicleRoutingSolution.setDistanceType(VehicleRoutingTspBasedGenerator.convert(tour.getDistanceType()));
        vehicleRoutingSolution.setDistanceUnitOfMeasurement(tour.getDistanceUnitOfMeasurement());
        List<Location> locationList = VehicleRoutingTspBasedGenerator.convert(tour.getLocationList());
        vehicleRoutingSolution.setLocationList(locationList);
        Location firstLocation = locationList.get(0);
        Depot depot = new Depot();
        depot.setId(firstLocation.getId());
        depot.setLocation(firstLocation);
        vehicleRoutingSolution.setDepotList(Collections.singletonList(depot));
        Vehicle vehicle = new Vehicle();
        vehicle.setId(firstLocation.getId());
        vehicle.setDepot(depot);
        vehicle.setCapacity(locationList.size() * 10);
        vehicleRoutingSolution.setVehicleList(Collections.singletonList(vehicle));
        ArrayList<Customer> customerList = new ArrayList<Customer>(locationList.size());
        for (Location location : locationList.subList(1, locationList.size())) {
            customer = new Customer();
            customer.setId(location.getId());
            customer.setLocation(location);
            customerList.add(customer);
        }
        for (Visit visit : tour.getVisitList()) {
            customer = (Customer)customerList.get(tour.getVisitList().indexOf(visit));
            Standstill previousStandstill = visit.getPreviousStandstill() instanceof Domicile ? vehicle : (Standstill)customerList.get(tour.getVisitList().indexOf(visit.getPreviousStandstill()));
            customer.setPreviousStandstill(previousStandstill);
            previousStandstill.setNextCustomer(customer);
        }
        vehicleRoutingSolution.setCustomerList(customerList);
        vehicleRoutingSolution.setScore(HardSoftScore.valueOf((int)0, (int)((int)tour.getScore().getScore())));
        return vehicleRoutingSolution;
    }

    private static List<Location> convert(List<org.optaplanner.examples.tsp.domain.location.Location> tspLocationList) {
        Location location;
        ArrayList<Location> locationList = new ArrayList<Location>(tspLocationList.size());
        for (org.optaplanner.examples.tsp.domain.location.Location tspLocation : tspLocationList) {
            if (tspLocation instanceof org.optaplanner.examples.tsp.domain.location.AirLocation) {
                location = new AirLocation();
            } else if (tspLocation instanceof org.optaplanner.examples.tsp.domain.location.RoadLocation) {
                location = new RoadLocation();
            } else {
                throw new IllegalStateException("The tspLocation class (" + tspLocation.getClass() + ") is not implemented.");
            }
            location.setName(tspLocation.getName());
            location.setLatitude(tspLocation.getLatitude());
            location.setLongitude(tspLocation.getLongitude());
            locationList.add(location);
        }
        for (org.optaplanner.examples.tsp.domain.location.Location tspLocation : tspLocationList) {
            if (!(tspLocation instanceof org.optaplanner.examples.tsp.domain.location.RoadLocation)) continue;
            location = (RoadLocation)locationList.get(tspLocationList.indexOf(tspLocation));
            LinkedHashMap<RoadLocation, Double> travelDistanceMap = new LinkedHashMap<RoadLocation, Double>(tspLocationList.size());
            Map<org.optaplanner.examples.tsp.domain.location.RoadLocation, Double> tspTravelDistanceMap = ((org.optaplanner.examples.tsp.domain.location.RoadLocation)tspLocation).getTravelDistanceMap();
            for (Map.Entry<org.optaplanner.examples.tsp.domain.location.RoadLocation, Double> entry : tspTravelDistanceMap.entrySet()) {
                travelDistanceMap.put((RoadLocation)locationList.get(tspLocationList.indexOf(entry.getKey())), entry.getValue());
            }
            ((RoadLocation)location).setTravelDistanceMap(travelDistanceMap);
        }
        return locationList;
    }

    private static DistanceType convert(org.optaplanner.examples.tsp.domain.location.DistanceType distanceType) {
        switch (distanceType) {
            case AIR_DISTANCE: {
                return DistanceType.AIR_DISTANCE;
            }
            case ROAD_DISTANCE: {
                return DistanceType.ROAD_DISTANCE;
            }
        }
        throw new IllegalStateException("The distanceType (" + (Object)((Object)distanceType) + ") is not implemented.");
    }
}

