/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusOrStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocation;
import org.optaplanner.examples.coachshuttlegathering.domain.solver.DepotAngleBusStopDifficultyWeightFactory;
import org.optaplanner.examples.coachshuttlegathering.domain.solver.TransportTimeToHubUpdatingVariableListener;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@PlanningEntity(difficultyWeightFactoryClass=DepotAngleBusStopDifficultyWeightFactory.class)
@XStreamAlias(value="CsgBusStop")
public class BusStop
extends AbstractPersistable
implements BusOrStop,
StopOrHub {
    protected String name;
    protected RoadLocation location;
    protected int passengerQuantity;
    protected int transportTimeLimit;
    protected BusOrStop previousBusOrStop;
    protected BusStop nextStop;
    protected Bus bus;
    protected List<Shuttle> transferShuttleList;
    protected Integer transportTimeToHub;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RoadLocation getLocation() {
        return this.location;
    }

    public void setLocation(RoadLocation location) {
        this.location = location;
    }

    public int getPassengerQuantity() {
        return this.passengerQuantity;
    }

    public void setPassengerQuantity(int passengerQuantity) {
        this.passengerQuantity = passengerQuantity;
    }

    public int getTransportTimeLimit() {
        return this.transportTimeLimit;
    }

    public void setTransportTimeLimit(int transportTimeLimit) {
        this.transportTimeLimit = transportTimeLimit;
    }

    @PlanningVariable(valueRangeProviderRefs={"coachRange", "shuttleRange", "stopRange"}, graphType=PlanningVariableGraphType.CHAINED)
    public BusOrStop getPreviousBusOrStop() {
        return this.previousBusOrStop;
    }

    public void setPreviousBusOrStop(BusOrStop previousBusOrStop) {
        this.previousBusOrStop = previousBusOrStop;
    }

    @Override
    public BusStop getNextStop() {
        return this.nextStop;
    }

    @Override
    public void setNextStop(BusStop nextStop) {
        this.nextStop = nextStop;
    }

    @Override
    @AnchorShadowVariable(sourceVariableName="previousBusOrStop")
    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @Override
    public List<Shuttle> getTransferShuttleList() {
        return this.transferShuttleList;
    }

    @Override
    public void setTransferShuttleList(List<Shuttle> transferShuttleList) {
        this.transferShuttleList = transferShuttleList;
    }

    @Override
    @CustomShadowVariable(variableListenerClass=TransportTimeToHubUpdatingVariableListener.class, sources={@CustomShadowVariable.Source(variableName="nextStop"), @CustomShadowVariable.Source(variableName="bus"), @CustomShadowVariable.Source(entityClass=Shuttle.class, variableName="destination")})
    public Integer getTransportTimeToHub() {
        return this.transportTimeToHub;
    }

    public void setTransportTimeToHub(Integer transportTimeToHub) {
        this.transportTimeToHub = transportTimeToHub;
    }

    public int getDistanceFromPreviousCost() {
        if (this.previousBusOrStop == null) {
            return 0;
        }
        return this.getDistanceFrom(this.previousBusOrStop) * this.bus.getMileageCost();
    }

    public int getDistanceFrom(BusOrStop busOrStop) {
        return this.bus.getDistanceFromTo(busOrStop.getLocation(), this.location);
    }

    public int getDistanceToDestinationCost(StopOrHub destination) {
        return this.bus.getDistanceFromTo(this.location, destination.getLocation()) * this.bus.getMileageCost();
    }

    @Override
    public boolean isVisitedByCoach() {
        return this.bus != null && this.bus instanceof Coach;
    }

    public Integer getTransportTimeRemainder() {
        if (this.transportTimeToHub == null) {
            return null;
        }
        if (this.passengerQuantity <= 0) {
            return 0;
        }
        return this.transportTimeLimit - this.transportTimeToHub;
    }

    public String getTransportLabel() {
        if (this.passengerQuantity <= 0) {
            return null;
        }
        return (this.transportTimeToHub == null ? "inf" : this.transportTimeToHub.toString()) + "/" + this.transportTimeLimit;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

