/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investmentallocation.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.investmentallocation.persistence.InvestmentAllocationDao;
import org.optaplanner.examples.investmentallocation.persistence.InvestmentAllocationImporter;
import org.optaplanner.examples.investmentallocation.swingui.InvestmentAllocationPanel;

public class InvestmentAllocationApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/investmentallocation/solver/investmentAllocationSolverConfig.xml";

    public static void main(String[] args) {
        InvestmentAllocationApp.prepareSwingEnvironment();
        new InvestmentAllocationApp().init();
    }

    public InvestmentAllocationApp() {
        super("Investment asset class allocation", "Decide the percentage of the investor's budget to invest in each asset class.", "/org/optaplanner/examples/investmentallocation/swingui/investmentAllocationLogo.png");
    }

    @Override
    protected Solver createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new InvestmentAllocationPanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new InvestmentAllocationDao();
    }

    @Override
    protected AbstractSolutionImporter createSolutionImporter() {
        return new InvestmentAllocationImporter();
    }
}

