/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.domain.location.AirLocation;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.swingui.TspListPanel;
import org.optaplanner.examples.tsp.swingui.TspWorldPanel;

public class TspPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/tsp/swingui/tspLogo.png";
    private TspWorldPanel tspWorldPanel;
    private TspListPanel tspListPanel;
    private Long nextLocationId = null;

    public TspPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.tspWorldPanel = new TspWorldPanel(this);
        this.tspWorldPanel.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        tabbedPane.add("World", this.tspWorldPanel);
        this.tspListPanel = new TspListPanel(this);
        JScrollPane tspListScrollPane = new JScrollPane(this.tspListPanel);
        tabbedPane.add("List", tspListScrollPane);
        this.add((Component)tabbedPane, "Center");
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public TravelingSalesmanTour getTravelingSalesmanTour() {
        return (TravelingSalesmanTour)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        this.tspWorldPanel.resetPanel(travelingSalesmanTour);
        this.tspListPanel.resetPanel(travelingSalesmanTour);
        this.resetNextLocationId();
    }

    private void resetNextLocationId() {
        long highestLocationId = 0L;
        for (Location location : this.getTravelingSalesmanTour().getLocationList()) {
            if (highestLocationId >= location.getId()) continue;
            highestLocationId = location.getId();
        }
        this.nextLocationId = highestLocationId + 1L;
    }

    @Override
    public void updatePanel(Solution solution) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        this.tspWorldPanel.updatePanel(travelingSalesmanTour);
        this.tspListPanel.updatePanel(travelingSalesmanTour);
    }

    public void doMove(Move move) {
        this.solutionBusiness.doMove(move);
    }

    public SolverAndPersistenceFrame getWorkflowFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void insertLocationAndVisit(double longitude, double latitude) {
        AirLocation newLocation;
        switch (this.getTravelingSalesmanTour().getDistanceType()) {
            case AIR_DISTANCE: {
                newLocation = new AirLocation();
                break;
            }
            case ROAD_DISTANCE: {
                this.logger.warn("Adding locations for a road distance dataset is not supported.");
                return;
            }
            default: {
                throw new IllegalStateException("The distanceType (" + (Object)((Object)this.getTravelingSalesmanTour().getDistanceType()) + ") is not implemented.");
            }
        }
        newLocation.setId(this.nextLocationId);
        Long l = this.nextLocationId;
        Long l2 = this.nextLocationId = Long.valueOf(this.nextLocationId + 1L);
        newLocation.setLongitude(longitude);
        newLocation.setLatitude(latitude);
        this.logger.info("Scheduling insertion of newLocation ({}).", (Object)newLocation);
        this.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                TravelingSalesmanTour solution = (TravelingSalesmanTour)scoreDirector.getWorkingSolution();
                scoreDirector.beforeProblemFactAdded((Object)newLocation);
                solution.getLocationList().add(newLocation);
                scoreDirector.afterProblemFactAdded((Object)newLocation);
                Visit newVisit = new Visit();
                newVisit.setId(newLocation.getId());
                newVisit.setLocation(newLocation);
                scoreDirector.beforeEntityAdded((Object)newVisit);
                solution.getVisitList().add(newVisit);
                scoreDirector.afterEntityAdded((Object)newVisit);
            }
        });
    }

    public void moveVisitToTail(AirLocation clickLocation) {
        TravelingSalesmanTour tour = this.getTravelingSalesmanTour();
        Visit visit = null;
        double minimumAirDistance = Double.MAX_VALUE;
        for (Visit selectedVisit : tour.getVisitList()) {
            double airDistance = selectedVisit.getLocation().getAirDistanceDoubleTo(clickLocation);
            if (!(airDistance < minimumAirDistance)) continue;
            visit = selectedVisit;
            minimumAirDistance = airDistance;
        }
        this.logger.info("Moving visit ({}) to tail.", visit);
        AbstractPersistable standstill = tour.getDomicile();
        Visit nextVisit = this.findNextVisit(tour, (Standstill)((Object)standstill));
        while (nextVisit != null) {
            standstill = nextVisit;
            nextVisit = this.findNextVisit(tour, (Standstill)((Object)standstill));
        }
        this.doMove(visit, (Standstill)((Object)standstill));
        this.getWorkflowFrame().resetScreen();
    }

    private Visit findNextVisit(TravelingSalesmanTour tour, Standstill standstill) {
        for (Visit visit : tour.getVisitList()) {
            if (visit.getPreviousStandstill() != standstill) continue;
            return visit;
        }
        return null;
    }

    public void doMove(Visit visit, Standstill toStandstill) {
        this.solutionBusiness.doChangeMove(visit, "previousStandstill", toStandstill);
    }
}

