/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;
import org.optaplanner.persistence.xstream.impl.score.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="VrpVehicleRoutingSolution")
@XStreamInclude(value={TimeWindowedVehicleRoutingSolution.class})
public class VehicleRoutingSolution
extends AbstractPersistable
implements Solution<HardSoftScore> {
    protected String name;
    protected DistanceType distanceType;
    protected String distanceUnitOfMeasurement;
    protected List<Location> locationList;
    protected List<Depot> depotList;
    protected List<Vehicle> vehicleList;
    protected List<Customer> customerList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftScoreDefinition.class})
    protected HardSoftScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
    }

    public String getDistanceUnitOfMeasurement() {
        return this.distanceUnitOfMeasurement;
    }

    public void setDistanceUnitOfMeasurement(String distanceUnitOfMeasurement) {
        this.distanceUnitOfMeasurement = distanceUnitOfMeasurement;
    }

    public List<Location> getLocationList() {
        return this.locationList;
    }

    public void setLocationList(List<Location> locationList) {
        this.locationList = locationList;
    }

    public List<Depot> getDepotList() {
        return this.depotList;
    }

    public void setDepotList(List<Depot> depotList) {
        this.depotList = depotList;
    }

    @PlanningEntityCollectionProperty
    @ValueRangeProvider(id="vehicleRange")
    public List<Vehicle> getVehicleList() {
        return this.vehicleList;
    }

    public void setVehicleList(List<Vehicle> vehicleList) {
        this.vehicleList = vehicleList;
    }

    @PlanningEntityCollectionProperty
    @ValueRangeProvider(id="customerRange")
    public List<Customer> getCustomerList() {
        return this.customerList;
    }

    public void setCustomerList(List<Customer> customerList) {
        this.customerList = customerList;
    }

    public HardSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.locationList);
        facts.addAll(this.depotList);
        return facts;
    }

    public String getDistanceString(NumberFormat numberFormat) {
        if (this.score == null) {
            return null;
        }
        int distance = -this.score.getSoftScore();
        if (this.distanceUnitOfMeasurement == null) {
            return numberFormat.format((double)distance / 1000.0);
        }
        if (this.distanceUnitOfMeasurement.equals("sec")) {
            int hours = distance / 3600000;
            int minutes = distance % 3600000 / 60000;
            int seconds = distance % 60000 / 1000;
            int milliseconds = distance % 1000;
            return hours + "h " + minutes + "m " + seconds + "s " + milliseconds + "ms";
        }
        if (this.distanceUnitOfMeasurement.equals("km")) {
            int km = distance / 1000;
            int meter = distance % 1000;
            return km + "km " + meter + "m";
        }
        if (this.distanceUnitOfMeasurement.equals("meter")) {
            int km = distance / 1000;
            int meter = distance % 1000;
            return km + "km " + meter + "m";
        }
        return numberFormat.format((double)distance / 1000.0) + " " + this.distanceUnitOfMeasurement;
    }
}

