/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.tracking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySorterManner;
import org.optaplanner.core.config.heuristic.selector.value.ValueSorterManner;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.persistence.NQueensGenerator;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracker;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracking;

@RunWith(value=Parameterized.class)
public class NQueensConstructionHeuristicTrackingTest {
    private final ConstructionHeuristicType constructionHeuristicType;
    private final EntitySorterManner entitySorterManner;
    private final ValueSorterManner valueSorterManner;
    private final List<NQueensStepTracking> expectedCoordinates;

    public NQueensConstructionHeuristicTrackingTest(ConstructionHeuristicType constructionHeuristicType, EntitySorterManner entitySorterManner, ValueSorterManner valueSorterManner, List<NQueensStepTracking> expectedCoordinates) {
        this.constructionHeuristicType = constructionHeuristicType;
        this.entitySorterManner = entitySorterManner;
        this.valueSorterManner = valueSorterManner;
        this.expectedCoordinates = expectedCoordinates;
    }

    @Test
    public void testConstructionHeuristics() {
        SolverConfig config = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/nqueens/solver/nqueensSolverConfig.xml").getSolverConfig();
        ConstructionHeuristicPhaseConfig chConfig = new ConstructionHeuristicPhaseConfig();
        chConfig.setValueSorterManner(this.valueSorterManner);
        chConfig.setEntitySorterManner(this.entitySorterManner);
        chConfig.setConstructionHeuristicType(this.constructionHeuristicType);
        config.setPhaseConfigList(Collections.singletonList(chConfig));
        NQueensGenerator generator = new NQueensGenerator();
        NQueens planningProblem = generator.createNQueens(8);
        NQueensStepTracker listener = new NQueensStepTracker();
        DefaultSolver solver = (DefaultSolver)config.buildSolver();
        solver.addPhaseLifecycleListener((PhaseLifecycleListener)listener);
        solver.solve((Solution)planningProblem);
        NQueens bestSolution = (NQueens)solver.getBestSolution();
        Assert.assertNotNull((Object)bestSolution);
        this.assertTrackingList(this.expectedCoordinates, listener.getTrackingList());
    }

    @Parameterized.Parameters(name="ConstructionHeuristicType: {0}, EntitySorterManner: {1}, ValueSorterManner: {2}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{ConstructionHeuristicType.FIRST_FIT, null, null, Arrays.asList(new NQueensStepTracking(0, 0), new NQueensStepTracking(1, 2), new NQueensStepTracking(2, 4), new NQueensStepTracking(3, 1), new NQueensStepTracking(4, 3), new NQueensStepTracking(5, 0), new NQueensStepTracking(6, 2), new NQueensStepTracking(7, 4))});
        params.add(new Object[]{ConstructionHeuristicType.FIRST_FIT_DECREASING, null, null, Arrays.asList(new NQueensStepTracking(4, 0), new NQueensStepTracking(3, 2), new NQueensStepTracking(5, 3), new NQueensStepTracking(2, 4), new NQueensStepTracking(6, 1), new NQueensStepTracking(1, 1), new NQueensStepTracking(7, 4), new NQueensStepTracking(0, 3))});
        params.add(new Object[]{ConstructionHeuristicType.WEAKEST_FIT, null, null, Arrays.asList(new NQueensStepTracking(0, 3), new NQueensStepTracking(1, 5), new NQueensStepTracking(2, 2), new NQueensStepTracking(3, 4), new NQueensStepTracking(4, 1), new NQueensStepTracking(5, 7), new NQueensStepTracking(6, 4), new NQueensStepTracking(7, 6))});
        params.add(new Object[]{ConstructionHeuristicType.WEAKEST_FIT_DECREASING, null, null, Arrays.asList(new NQueensStepTracking(4, 3), new NQueensStepTracking(3, 5), new NQueensStepTracking(5, 1), new NQueensStepTracking(2, 2), new NQueensStepTracking(6, 4), new NQueensStepTracking(1, 4), new NQueensStepTracking(7, 2), new NQueensStepTracking(0, 1))});
        params.add(new Object[]{ConstructionHeuristicType.STRONGEST_FIT, null, null, Arrays.asList(new NQueensStepTracking(0, 7), new NQueensStepTracking(1, 0), new NQueensStepTracking(2, 6), new NQueensStepTracking(3, 1), new NQueensStepTracking(4, 5), new NQueensStepTracking(5, 7), new NQueensStepTracking(6, 0), new NQueensStepTracking(7, 4))});
        params.add(new Object[]{ConstructionHeuristicType.STRONGEST_FIT_DECREASING, null, null, Arrays.asList(new NQueensStepTracking(4, 7), new NQueensStepTracking(3, 0), new NQueensStepTracking(5, 1), new NQueensStepTracking(2, 6), new NQueensStepTracking(6, 4), new NQueensStepTracking(1, 3), new NQueensStepTracking(7, 2), new NQueensStepTracking(0, 5))});
        params.add(new Object[]{ConstructionHeuristicType.CHEAPEST_INSERTION, null, null, Arrays.asList(new NQueensStepTracking(4, 3), new NQueensStepTracking(3, 5), new NQueensStepTracking(5, 1), new NQueensStepTracking(2, 2), new NQueensStepTracking(6, 4), new NQueensStepTracking(1, 4), new NQueensStepTracking(7, 2), new NQueensStepTracking(0, 1))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, null, null, Arrays.asList(new NQueensStepTracking(4, 3), new NQueensStepTracking(3, 5), new NQueensStepTracking(5, 1), new NQueensStepTracking(2, 2), new NQueensStepTracking(6, 4), new NQueensStepTracking(1, 4), new NQueensStepTracking(7, 2), new NQueensStepTracking(0, 1))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, EntitySorterManner.NONE, ValueSorterManner.NONE, Arrays.asList(new NQueensStepTracking(0, 0), new NQueensStepTracking(1, 2), new NQueensStepTracking(2, 4), new NQueensStepTracking(3, 1), new NQueensStepTracking(4, 3), new NQueensStepTracking(5, 0), new NQueensStepTracking(6, 2), new NQueensStepTracking(7, 4))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, EntitySorterManner.DECREASING_DIFFICULTY, ValueSorterManner.NONE, Arrays.asList(new NQueensStepTracking(4, 0), new NQueensStepTracking(3, 2), new NQueensStepTracking(5, 3), new NQueensStepTracking(2, 4), new NQueensStepTracking(6, 1), new NQueensStepTracking(1, 1), new NQueensStepTracking(7, 4), new NQueensStepTracking(0, 3))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, EntitySorterManner.DECREASING_DIFFICULTY_IF_AVAILABLE, ValueSorterManner.NONE, Arrays.asList(new NQueensStepTracking(4, 0), new NQueensStepTracking(3, 2), new NQueensStepTracking(5, 3), new NQueensStepTracking(2, 4), new NQueensStepTracking(6, 1), new NQueensStepTracking(1, 1), new NQueensStepTracking(7, 4), new NQueensStepTracking(0, 3))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, EntitySorterManner.NONE, ValueSorterManner.INCREASING_STRENGTH, Arrays.asList(new NQueensStepTracking(0, 3), new NQueensStepTracking(1, 5), new NQueensStepTracking(2, 2), new NQueensStepTracking(3, 4), new NQueensStepTracking(4, 1), new NQueensStepTracking(5, 7), new NQueensStepTracking(6, 4), new NQueensStepTracking(7, 6))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, EntitySorterManner.NONE, ValueSorterManner.DECREASING_STRENGTH, Arrays.asList(new NQueensStepTracking(0, 7), new NQueensStepTracking(1, 0), new NQueensStepTracking(2, 6), new NQueensStepTracking(3, 1), new NQueensStepTracking(4, 5), new NQueensStepTracking(5, 7), new NQueensStepTracking(6, 0), new NQueensStepTracking(7, 4))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, EntitySorterManner.DECREASING_DIFFICULTY, ValueSorterManner.DECREASING_STRENGTH_IF_AVAILABLE, Arrays.asList(new NQueensStepTracking(4, 7), new NQueensStepTracking(3, 0), new NQueensStepTracking(5, 1), new NQueensStepTracking(2, 6), new NQueensStepTracking(6, 4), new NQueensStepTracking(1, 3), new NQueensStepTracking(7, 2), new NQueensStepTracking(0, 5))});
        params.add(new Object[]{ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE, EntitySorterManner.DECREASING_DIFFICULTY, ValueSorterManner.INCREASING_STRENGTH_IF_AVAILABLE, Arrays.asList(new NQueensStepTracking(4, 3), new NQueensStepTracking(3, 5), new NQueensStepTracking(5, 1), new NQueensStepTracking(2, 2), new NQueensStepTracking(6, 4), new NQueensStepTracking(1, 4), new NQueensStepTracking(7, 2), new NQueensStepTracking(0, 1))});
        return params;
    }

    private void assertTrackingList(List<NQueensStepTracking> expected, List<NQueensStepTracking> recorded) {
        Assert.assertEquals((long)expected.size(), (long)recorded.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((long)expected.get(i).getColumnIndex(), (long)recorded.get(i).getColumnIndex());
            Assert.assertEquals((long)expected.get(i).getRowIndex(), (long)recorded.get(i).getRowIndex());
        }
    }
}

