/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.tracking;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.testdata.util.listeners.StepTestListener;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracking;

public class NQueensStepTracker
extends StepTestListener {
    private List<Integer> filledColumns = new ArrayList<Integer>();
    private List<NQueensStepTracking> trackingList = new ArrayList<NQueensStepTracking>();

    public void stepEnded(AbstractStepScope stepScope) {
        NQueens queens = (NQueens)stepScope.getWorkingSolution();
        for (Queen queen : queens.getQueenList()) {
            if (queen.getRow() == null || this.filledColumns.contains(queen.getColumn().getIndex())) continue;
            this.filledColumns.add(queen.getColumn().getIndex());
            this.trackingList.add(new NQueensStepTracking(queen.getColumnIndex(), queen.getRowIndex()));
        }
    }

    public List<NQueensStepTracking> getTrackingList() {
        return this.trackingList;
    }
}

