/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.investment.domain.AssetClass;
import org.optaplanner.examples.investment.domain.Region;
import org.optaplanner.examples.investment.domain.util.InvestmentNumericUtil;

@PlanningEntity
@XStreamAlias(value="AssetClassAllocation")
public class AssetClassAllocation
extends AbstractPersistable {
    private AssetClass assetClass;
    private Long quantityMillis;

    public static long calculateSquaredStandardDeviationFemtosFromTo(AssetClassAllocation from, AssetClassAllocation to) {
        if (from == to) {
            long micros = from.getQuantifiedStandardDeviationRiskMicros();
            return micros * micros * 1000L;
        }
        long picos = from.getQuantifiedStandardDeviationRiskMicros() * to.getQuantifiedStandardDeviationRiskMicros();
        long correlationMillis = from.getAssetClass().getCorrelationMillisMap().get(to.getAssetClass());
        return picos * correlationMillis;
    }

    public AssetClass getAssetClass() {
        return this.assetClass;
    }

    public void setAssetClass(AssetClass assetClass) {
        this.assetClass = assetClass;
    }

    @PlanningVariable(valueRangeProviderRefs={"quantityMillisRange"})
    public Long getQuantityMillis() {
        return this.quantityMillis;
    }

    public void setQuantityMillis(Long quantityMillis) {
        this.quantityMillis = quantityMillis;
    }

    public Region getRegion() {
        return this.assetClass.getRegion();
    }

    public long getQuantifiedExpectedReturnMicros() {
        if (this.quantityMillis == null) {
            return 0L;
        }
        return this.quantityMillis * this.assetClass.getExpectedReturnMillis();
    }

    public long getQuantifiedStandardDeviationRiskMicros() {
        if (this.quantityMillis == null) {
            return 0L;
        }
        return this.quantityMillis * this.assetClass.getStandardDeviationRiskMillis();
    }

    public String getQuantityLabel() {
        if (this.quantityMillis == null) {
            return "";
        }
        return InvestmentNumericUtil.formatMillisAsPercentage(this.quantityMillis);
    }

    public String getLabel() {
        return this.assetClass.getName();
    }

    @Override
    public String toString() {
        return this.assetClass.toString();
    }
}

