/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvestmentIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<InvestmentSolution> {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private InvestmentSolution solution;
    private long squaredStandardDeviationFemtosMaximum;
    private long squaredStandardDeviationFemtos;
    private long hardScore;
    private long softScore;

    public void resetWorkingSolution(InvestmentSolution solution) {
        this.solution = solution;
        this.squaredStandardDeviationFemtosMaximum = solution.getParametrization().calculateSquaredStandardDeviationFemtosMaximum();
        this.squaredStandardDeviationFemtos = 0L;
        this.hardScore = 0L;
        this.softScore = 0L;
        for (AssetClassAllocation allocation : solution.getAssetClassAllocationList()) {
            this.insertQuantityMillis(allocation, true);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insertQuantityMillis((AssetClassAllocation)entity, false);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retractQuantityMillis((AssetClassAllocation)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insertQuantityMillis((AssetClassAllocation)entity, false);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retractQuantityMillis((AssetClassAllocation)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insertQuantityMillis(AssetClassAllocation allocation, boolean reset) {
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore += this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        this.squaredStandardDeviationFemtos += this.calculateStandardDeviationSquaredFemtosDelta(allocation, reset);
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore -= this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        this.softScore += allocation.getQuantifiedExpectedReturnMicros();
    }

    private void retractQuantityMillis(AssetClassAllocation allocation) {
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore += this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        this.squaredStandardDeviationFemtos -= this.calculateStandardDeviationSquaredFemtosDelta(allocation, false);
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore -= this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        this.softScore -= allocation.getQuantifiedExpectedReturnMicros();
    }

    private long calculateStandardDeviationSquaredFemtosDelta(AssetClassAllocation allocation, boolean reset) {
        long squaredFemtos = 0L;
        for (AssetClassAllocation other : this.solution.getAssetClassAllocationList()) {
            if (allocation == other) {
                long micros = allocation.getQuantifiedStandardDeviationRiskMicros();
                squaredFemtos += micros * micros * 1000L;
                continue;
            }
            long picos = allocation.getQuantifiedStandardDeviationRiskMicros() * other.getQuantifiedStandardDeviationRiskMicros();
            squaredFemtos += picos * allocation.getAssetClass().getCorrelationMillisMap().get(other.getAssetClass());
            if (reset) continue;
            squaredFemtos += picos * other.getAssetClass().getCorrelationMillisMap().get(allocation.getAssetClass());
        }
        return squaredFemtos;
    }

    public Score calculateScore() {
        return HardSoftLongScore.valueOf((long)this.hardScore, (long)this.softScore);
    }
}

