/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.swingui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.LinkedHashMap;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.YIntervalRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;
import org.optaplanner.examples.projectjobscheduling.domain.Project;
import org.optaplanner.examples.projectjobscheduling.domain.Schedule;

public class ProjectJobSchedulingPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/projectjobscheduling/swingui/projectJobSchedulingLogo.png";

    public ProjectJobSchedulingPanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    @Override
    public void resetPanel(Solution solution) {
        this.removeAll();
        Schedule schedule = (Schedule)solution;
        ChartPanel chartPanel = new ChartPanel(this.createChart(schedule));
        this.add((Component)chartPanel, "Center");
    }

    private JFreeChart createChart(Schedule schedule) {
        YIntervalSeriesCollection seriesCollection = new YIntervalSeriesCollection();
        LinkedHashMap<Project, YIntervalSeries> projectSeriesMap = new LinkedHashMap<Project, YIntervalSeries>(schedule.getProjectList().size());
        YIntervalRenderer renderer = new YIntervalRenderer();
        int maximumEndDate = 0;
        int seriesIndex = 0;
        for (Project project : schedule.getProjectList()) {
            YIntervalSeries projectSeries = new YIntervalSeries((Comparable)((Object)project.getLabel()));
            seriesCollection.addSeries(projectSeries);
            projectSeriesMap.put(project, projectSeries);
            renderer.setSeriesShape(seriesIndex, (Shape)new Rectangle());
            renderer.setSeriesStroke(seriesIndex, (Stroke)new BasicStroke(3.0f));
            ++seriesIndex;
        }
        for (Allocation allocation : schedule.getAllocationList()) {
            int startDate = allocation.getStartDate();
            int endDate = allocation.getEndDate();
            YIntervalSeries projectSeries = (YIntervalSeries)projectSeriesMap.get(allocation.getProject());
            projectSeries.add((double)allocation.getId().longValue(), (double)(startDate + endDate) / 2.0, (double)startDate, (double)endDate);
            maximumEndDate = Math.max(maximumEndDate, endDate);
        }
        NumberAxis domainAxis = new NumberAxis("Job");
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domainAxis.setRange(-0.5, (double)schedule.getAllocationList().size() - 0.5);
        domainAxis.setInverted(true);
        NumberAxis rangeAxis = new NumberAxis("Day (start to end date)");
        rangeAxis.setRange(-0.5, (double)maximumEndDate + 0.5);
        XYPlot plot = new XYPlot((XYDataset)seriesCollection, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        return new JFreeChart("Project Job Scheduling", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }
}

