/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.tracking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorType;
import org.optaplanner.core.config.localsearch.decider.forager.LocalSearchForagerConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.persistence.NQueensGenerator;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensAbstractTrackingTest;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensSolutionInitializer;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracker;
import org.optaplanner.examples.nqueens.solver.tracking.NQueensStepTracking;

@RunWith(value=Parameterized.class)
public class NQueensLocalSearchTrackingTest
extends NQueensAbstractTrackingTest {
    private static final int N = 6;
    private final AcceptorConfig acceptorConfig;
    private final LocalSearchForagerConfig localSearchForagerConfig;
    private final List<NQueensStepTracking> expectedCoordinates;

    public NQueensLocalSearchTrackingTest(AcceptorConfig acceptorConfig, LocalSearchForagerConfig localSearchForagerConfig, List<NQueensStepTracking> expectedCoordinates) {
        this.expectedCoordinates = expectedCoordinates;
        this.localSearchForagerConfig = localSearchForagerConfig;
        this.acceptorConfig = acceptorConfig;
    }

    @Test
    public void trackLocalSearch() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/nqueens/solver/nqueensSolverConfig.xml");
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        NQueensGenerator generator = new NQueensGenerator();
        NQueens planningProblem = NQueensSolutionInitializer.initialize(generator.createNQueens(6));
        LocalSearchPhaseConfig localSearchPhaseConfig = new LocalSearchPhaseConfig();
        localSearchPhaseConfig.setAcceptorConfig(this.acceptorConfig);
        localSearchPhaseConfig.setForagerConfig(this.localSearchForagerConfig);
        localSearchPhaseConfig.getForagerConfig().setBreakTieRandomly(Boolean.valueOf(false));
        localSearchPhaseConfig.setMoveSelectorConfig((MoveSelectorConfig)new ChangeMoveSelectorConfig());
        localSearchPhaseConfig.getMoveSelectorConfig().setSelectionOrder(SelectionOrder.ORIGINAL);
        localSearchPhaseConfig.setTerminationConfig(new TerminationConfig());
        localSearchPhaseConfig.getTerminationConfig().setStepCountLimit(Integer.valueOf(20));
        solverConfig.getPhaseConfigList().set(1, localSearchPhaseConfig);
        NQueensStepTracker listener = new NQueensStepTracker();
        DefaultSolver solver = (DefaultSolver)solverFactory.buildSolver();
        solver.addPhaseLifecycleListener((PhaseLifecycleListener)listener);
        solver.solve((Solution)planningProblem);
        NQueens bestSolution = (NQueens)solver.getBestSolution();
        Assert.assertNotNull((Object)bestSolution);
        this.assertTrackingList(this.expectedCoordinates, listener.getTrackingList());
    }

    @Parameterized.Parameters(name="AcceptorType: {0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        AcceptorConfig acceptorConfig = new AcceptorConfig();
        LocalSearchForagerConfig localSearchForagerConfig = new LocalSearchForagerConfig();
        localSearchForagerConfig.setAcceptedCountLimit(Integer.valueOf(36));
        acceptorConfig.setAcceptorTypeList(Arrays.asList(AcceptorType.HILL_CLIMBING));
        params.add(new Object[]{acceptorConfig, localSearchForagerConfig, Arrays.asList(new NQueensStepTracking(1, 5), new NQueensStepTracking(0, 1), new NQueensStepTracking(4, 3), new NQueensStepTracking(2, 2), new NQueensStepTracking(3, 5), new NQueensStepTracking(1, 4), new NQueensStepTracking(1, 5), new NQueensStepTracking(1, 4), new NQueensStepTracking(1, 5))});
        acceptorConfig = new AcceptorConfig();
        acceptorConfig.setAcceptorTypeList(Arrays.asList(AcceptorType.ENTITY_TABU));
        acceptorConfig.setEntityTabuSize(Integer.valueOf(5));
        localSearchForagerConfig = new LocalSearchForagerConfig();
        localSearchForagerConfig.setAcceptedCountLimit(Integer.valueOf(36));
        params.add(new Object[]{acceptorConfig, localSearchForagerConfig, Arrays.asList(new NQueensStepTracking(1, 5), new NQueensStepTracking(0, 1), new NQueensStepTracking(4, 3), new NQueensStepTracking(2, 2), new NQueensStepTracking(3, 5), new NQueensStepTracking(5, 4), new NQueensStepTracking(1, 4), new NQueensStepTracking(0, 0), new NQueensStepTracking(4, 1))});
        acceptorConfig = new AcceptorConfig();
        acceptorConfig.setAcceptorTypeList(Arrays.asList(AcceptorType.LATE_ACCEPTANCE));
        acceptorConfig.setLateAcceptanceSize(Integer.valueOf(1));
        localSearchForagerConfig = new LocalSearchForagerConfig();
        localSearchForagerConfig.setAcceptedCountLimit(Integer.valueOf(1));
        params.add(new Object[]{acceptorConfig, localSearchForagerConfig, Arrays.asList(new NQueensStepTracking(0, 1), new NQueensStepTracking(0, 2), new NQueensStepTracking(0, 1), new NQueensStepTracking(0, 2), new NQueensStepTracking(0, 1), new NQueensStepTracking(0, 2))});
        return params;
    }
}

