/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.domain.location.AirLocation;
import org.optaplanner.examples.tsp.domain.location.DistanceType;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.domain.location.RoadLocation;
import org.optaplanner.examples.tsp.persistence.TspDao;

public class TspImporter
extends AbstractTxtSolutionImporter {
    public static final String INPUT_FILE_SUFFIX = "tsp";

    public static void main(String[] args) {
        TspImporter importer = new TspImporter();
        importer.convert("other/air/europe40.tsp", "europe40.xml");
        importer.convert("cook/air/dj38.tsp", "dj38.xml");
        importer.convert("cook/air/lu980.tsp", "lu980.xml");
    }

    public TspImporter() {
        super(new TspDao());
    }

    public TspImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new TspInputBuilder();
    }

    public static class TspInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private TravelingSalesmanTour travelingSalesmanTour;
        private int locationListSize;

        @Override
        public Solution readSolution() throws IOException {
            this.travelingSalesmanTour = new TravelingSalesmanTour();
            this.travelingSalesmanTour.setId(0L);
            String firstLine = this.readStringValue();
            if (firstLine.matches("\\s*NAME\\s*:.*")) {
                this.travelingSalesmanTour.setName(this.removePrefixSuffixFromLine(firstLine, "\\s*NAME\\s*:", ""));
                this.readTspLibFormat();
            } else {
                this.travelingSalesmanTour.setName(FilenameUtils.getBaseName((String)this.inputFile.getName()));
                this.locationListSize = Integer.parseInt(firstLine.trim());
                this.readCourseraFormat();
            }
            BigInteger possibleSolutionSize = this.factorial(this.travelingSalesmanTour.getLocationList().size() - 1);
            this.logger.info("TravelingSalesmanTour {} has {} locations with a search space of {}.", new Object[]{this.getInputId(), this.travelingSalesmanTour.getLocationList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.travelingSalesmanTour;
        }

        private void readTspLibFormat() throws IOException {
            this.readTspLibHeaders();
            this.readTspLibCityList();
            this.createVisitList();
            this.readTspLibSolution();
            this.readConstantLine("EOF");
        }

        private void readTspLibHeaders() throws IOException {
            this.readUntilConstantLine("TYPE *: +TSP");
            this.locationListSize = this.readIntegerValue("DIMENSION *:");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE *:");
            if (edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                this.travelingSalesmanTour.setDistanceType(DistanceType.AIR_DISTANCE);
            } else if (edgeWeightType.equalsIgnoreCase("EXPLICIT")) {
                this.travelingSalesmanTour.setDistanceType(DistanceType.ROAD_DISTANCE);
                String edgeWeightFormat = this.readStringValue("EDGE_WEIGHT_FORMAT *:");
                if (!edgeWeightFormat.equalsIgnoreCase("FULL_MATRIX")) {
                    throw new IllegalArgumentException("The edgeWeightFormat (" + edgeWeightFormat + ") is not supported.");
                }
            } else {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
            this.travelingSalesmanTour.setDistanceUnitOfMeasurement(this.readOptionalStringValue("EDGE_WEIGHT_UNIT_OF_MEASUREMENT *:", "distance"));
        }

        private void readTspLibCityList() throws IOException {
            int i;
            this.readConstantLine("NODE_COORD_SECTION");
            DistanceType distanceType = this.travelingSalesmanTour.getDistanceType();
            ArrayList<Location> locationList = new ArrayList<Location>(this.locationListSize);
            for (i = 0; i < this.locationListSize; ++i) {
                Location location;
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 3, 4, false, true);
                switch (distanceType) {
                    case AIR_DISTANCE: {
                        location = new AirLocation();
                        break;
                    }
                    case ROAD_DISTANCE: {
                        location = new RoadLocation();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The distanceType (" + (Object)((Object)distanceType) + ") is not implemented.");
                    }
                }
                location.setId(Long.parseLong(lineTokens[0]));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
            }
            this.travelingSalesmanTour.setLocationList(locationList);
            if (distanceType == DistanceType.ROAD_DISTANCE) {
                this.readConstantLine("EDGE_WEIGHT_SECTION");
                for (i = 0; i < this.locationListSize; ++i) {
                    RoadLocation location = (RoadLocation)locationList.get(i);
                    LinkedHashMap<RoadLocation, Double> travelDistanceMap = new LinkedHashMap<RoadLocation, Double>(this.locationListSize);
                    String line = this.bufferedReader.readLine();
                    String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), this.locationListSize);
                    for (int j = 0; j < this.locationListSize; ++j) {
                        double travelDistance = Double.parseDouble(lineTokens[j]);
                        if (i == j) {
                            if (travelDistance == 0.0) continue;
                            throw new IllegalStateException("The travelDistance (" + travelDistance + ") should be zero.");
                        }
                        RoadLocation otherLocation = (RoadLocation)locationList.get(j);
                        travelDistanceMap.put(otherLocation, travelDistance);
                    }
                    location.setTravelDistanceMap(travelDistanceMap);
                }
            }
        }

        private void createVisitList() {
            List<Location> locationList = this.travelingSalesmanTour.getLocationList();
            ArrayList<Visit> visitList = new ArrayList<Visit>(locationList.size() - 1);
            int count = 0;
            for (Location location : locationList) {
                if (count < 1) {
                    Domicile domicile = new Domicile();
                    domicile.setId(location.getId());
                    domicile.setLocation(location);
                    this.travelingSalesmanTour.setDomicile(domicile);
                } else {
                    Visit visit = new Visit();
                    visit.setId(location.getId());
                    visit.setLocation(location);
                    visitList.add(visit);
                }
                ++count;
            }
            this.travelingSalesmanTour.setVisitList(visitList);
        }

        private void readTspLibSolution() throws IOException {
            boolean enabled = this.readOptionalConstantLine("TOUR_SECTION");
            if (!enabled) {
                return;
            }
            long domicileId = this.readLongValue();
            Domicile domicile = this.travelingSalesmanTour.getDomicile();
            if (!domicile.getId().equals(domicileId)) {
                throw new IllegalStateException("The domicileId (" + domicileId + ") is not the domicile's id (" + domicile.getId() + ").");
            }
            int visitListSize = this.travelingSalesmanTour.getVisitList().size();
            HashMap<Long, Visit> idToVisitMap = new HashMap<Long, Visit>(visitListSize);
            for (Visit visit : this.travelingSalesmanTour.getVisitList()) {
                idToVisitMap.put(visit.getId(), visit);
            }
            AbstractPersistable previousStandstill = domicile;
            for (int i = 0; i < visitListSize; ++i) {
                long visitId = this.readLongValue();
                Visit visit = (Visit)idToVisitMap.get(visitId);
                if (visit == null) {
                    throw new IllegalStateException("The visitId (" + visitId + ") is does not exist.");
                }
                visit.setPreviousStandstill((Standstill)((Object)previousStandstill));
                previousStandstill = visit;
            }
        }

        private void readCourseraFormat() throws IOException {
            ArrayList<Location> locationList = new ArrayList<Location>(this.locationListSize);
            long id = 0L;
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 2);
                AirLocation location = new AirLocation();
                location.setId(id);
                ++id;
                location.setLatitude(Double.parseDouble(lineTokens[0]));
                location.setLongitude(Double.parseDouble(lineTokens[1]));
                locationList.add(location);
            }
            this.travelingSalesmanTour.setLocationList(locationList);
            this.createVisitList();
        }
    }
}

