/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.app;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;
import org.optaplanner.examples.common.app.LoggingTest;

public class CloudBalancingDaemonTest
extends LoggingTest {
    private Object stageLock = new Object();
    private AtomicInteger stageNumber = new AtomicInteger(0);
    private CountDownLatch stage1Latch = new CountDownLatch(1);
    private CountDownLatch stage2Latch = new CountDownLatch(1);
    private CountDownLatch stage3Latch = new CountDownLatch(1);
    private Queue<CloudProcess> notYetAddedProcessQueue = new ArrayDeque<CloudProcess>();

    @Test(timeout=600000L)
    public void daemon() throws InterruptedException {
        Solver<CloudBalance> solver = this.buildSolver();
        CloudBalance cloudBalance = this.buildPlanningProblem(4, 12);
        SolverThread solverThread = new SolverThread(solver, cloudBalance);
        solverThread.start();
        this.waitForNextStage();
        Thread.sleep(500L);
        for (int i = 0; i < 8; ++i) {
            CloudProcess process = this.notYetAddedProcessQueue.poll();
            solver.addProblemFactChange((ProblemFactChange)new AddProcessChange(process));
        }
        this.waitForNextStage();
        Assert.assertEquals((long)8L, (long)((CloudBalance)solver.getBestSolution()).getProcessList().size());
        Thread.sleep(1000L);
        while (!this.notYetAddedProcessQueue.isEmpty()) {
            CloudProcess process = this.notYetAddedProcessQueue.poll();
            solver.addProblemFactChange((ProblemFactChange)new AddProcessChange(process));
        }
        this.waitForNextStage();
        solver.terminateEarly();
        try {
            solverThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("SolverThread did not die yet due to an interruption.", e);
        }
        Assert.assertEquals((Object)true, (Object)solver.isEveryProblemFactChangeProcessed());
        Assert.assertEquals((long)12L, (long)((CloudBalance)solver.getBestSolution()).getProcessList().size());
    }

    protected Solver<CloudBalance> buildSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml");
        solverFactory.getSolverConfig().setDaemon(Boolean.valueOf(true));
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setBestScoreFeasible(Boolean.valueOf(true));
        solverFactory.getSolverConfig().setTerminationConfig(terminationConfig);
        return solverFactory.buildSolver();
    }

    private CloudBalance buildPlanningProblem(int computerListSize, int processListSize) {
        CloudBalance cloudBalance = new CloudBalancingGenerator().createCloudBalance(computerListSize, processListSize);
        this.notYetAddedProcessQueue.addAll(cloudBalance.getProcessList());
        cloudBalance.setProcessList(new ArrayList(this.notYetAddedProcessQueue.size()));
        return cloudBalance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNextStage() throws InterruptedException {
        int stage;
        CountDownLatch latch;
        Object object = this.stageLock;
        synchronized (object) {
            switch (this.stageNumber.get()) {
                case 0: {
                    latch = this.stage1Latch;
                    break;
                }
                case 1: {
                    latch = this.stage2Latch;
                    break;
                }
                case 2: {
                    latch = this.stage3Latch;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported phaseNumber (" + this.stageNumber.get() + ").");
                }
            }
        }
        latch.await();
        Object object2 = this.stageLock;
        synchronized (object2) {
            stage = this.stageNumber.incrementAndGet();
        }
        this.logger.info("==== New testing stage ({}) started. ====", (Object)stage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextStage() {
        Object object = this.stageLock;
        synchronized (object) {
            switch (this.stageNumber.get()) {
                case 0: {
                    this.stage1Latch.countDown();
                    break;
                }
                case 1: {
                    this.stage2Latch.countDown();
                    break;
                }
                case 2: {
                    this.stage3Latch.countDown();
                }
            }
        }
    }

    private static class AddProcessChange
    implements ProblemFactChange {
        private final CloudProcess process;

        private AddProcessChange(CloudProcess process) {
            this.process = process;
        }

        public void doChange(ScoreDirector scoreDirector) {
            CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
            scoreDirector.beforeEntityAdded((Object)this.process);
            cloudBalance.getProcessList().add(this.process);
            scoreDirector.afterEntityAdded((Object)this.process);
            scoreDirector.triggerVariableListeners();
        }
    }

    private class SolverThread
    extends Thread
    implements SolverEventListener<CloudBalance> {
        private final Solver<CloudBalance> solver;
        private final CloudBalance cloudBalance;

        private SolverThread(Solver<CloudBalance> solver, CloudBalance cloudBalance) {
            this.solver = solver;
            this.cloudBalance = cloudBalance;
        }

        @Override
        public void run() {
            this.solver.addEventListener((SolverEventListener)this);
            CloudBalancingDaemonTest.this.nextStage();
            this.solver.solve((Solution)this.cloudBalance);
        }

        public void bestSolutionChanged(BestSolutionChangedEvent<CloudBalance> event) {
            if (event.isEveryProblemFactChangeProcessed() && event.isNewBestSolutionInitialized() && ((CloudBalance)event.getNewBestSolution()).getScore().isFeasible()) {
                CloudBalancingDaemonTest.this.nextStage();
            }
        }
    }
}

