/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.app.SolveAllTurtleTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class UnsolvedDirSolveAllTurtleTest
extends SolveAllTurtleTest {
    protected File dataFile;
    protected SolutionDao solutionDao;

    protected static Collection<Object[]> getUnsolvedDirFilesAsParameters(SolutionDao solutionDao) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        File dataDir = solutionDao.getDataDir();
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        ArrayList fileList = new ArrayList(FileUtils.listFiles((File)unsolvedDataDir, (String[])new String[]{solutionDao.getFileExtension()}, (boolean)true));
        Collections.sort(fileList, new ProblemFileComparator());
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected UnsolvedDirSolveAllTurtleTest(File dataFile) {
        this.dataFile = dataFile;
    }

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
    }

    protected abstract SolutionDao createSolutionDao();

    @Override
    protected Solution readPlanningProblem() {
        return this.solutionDao.readSolution(this.dataFile);
    }
}

