/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.persistence;

import java.io.IOException;
import java.util.Collections;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.domain.PersistableIdComparator;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.persistence.ExaminationDao;

public class ExaminationExporter
extends AbstractTxtSolutionExporter {
    private static final String OUTPUT_FILE_SUFFIX = "sln";

    public static void main(String[] args) {
        new ExaminationExporter().convertAll();
    }

    public ExaminationExporter() {
        super(new ExaminationDao());
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new ExaminationOutputBuilder();
    }

    public static class ExaminationOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private Examination examination;

        @Override
        public void setSolution(Solution solution) {
            this.examination = (Examination)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            Collections.sort(this.examination.getExamList(), new PersistableIdComparator());
            for (Exam exam : this.examination.getExamList()) {
                this.bufferedWriter.write(exam.getPeriod().getId() + ", " + exam.getRoom().getId() + "\r\n");
            }
        }
    }
}

