/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchType;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.PhaseTest;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class ExhaustiveSearchTest
extends PhaseTest {
    protected ExhaustiveSearchType exhaustiveSearchType;

    protected static Collection<Object[]> buildParameters(SolutionDao solutionDao, String ... unsolvedFileNames) {
        return ExhaustiveSearchTest.buildParameters((SolutionDao)solutionDao, (Enum[])ExhaustiveSearchType.values(), (String[])unsolvedFileNames);
    }

    protected ExhaustiveSearchTest(File dataFile, ExhaustiveSearchType exhaustiveSearchType) {
        super(dataFile);
        this.exhaustiveSearchType = exhaustiveSearchType;
    }

    @Override
    protected SolverFactory<Solution> buildSolverFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.createSolverConfigResource());
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.setTerminationConfig(new TerminationConfig());
        ExhaustiveSearchPhaseConfig exhaustiveSearchPhaseConfig = new ExhaustiveSearchPhaseConfig();
        exhaustiveSearchPhaseConfig.setExhaustiveSearchType(this.exhaustiveSearchType);
        solverConfig.setPhaseConfigList(Arrays.asList(exhaustiveSearchPhaseConfig));
        return solverFactory;
    }
}

