/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.scrabble.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.scrabble.domain.ScrabbleCell;
import org.optaplanner.examples.scrabble.domain.ScrabbleSolution;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordDirection;
import org.optaplanner.examples.scrabble.domain.solver.ScrabbleWordAssignmentDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=ScrabbleWordAssignmentDifficultyComparator.class)
@XStreamAlias(value="ScrabbleWord")
public class ScrabbleWordAssignment
extends AbstractPersistable {
    private ScrabbleSolution solution;
    private String word;
    @PlanningVariable(valueRangeProviderRefs={"startCellRange"})
    private ScrabbleCell startCell;
    @PlanningVariable(valueRangeProviderRefs={"directionRange"})
    private ScrabbleWordDirection direction;

    public ScrabbleSolution getSolution() {
        return this.solution;
    }

    public void setSolution(ScrabbleSolution solution) {
        this.solution = solution;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public ScrabbleCell getStartCell() {
        return this.startCell;
    }

    public void setStartCell(ScrabbleCell startCell) {
        this.startCell = startCell;
    }

    public ScrabbleWordDirection getDirection() {
        return this.direction;
    }

    public void setDirection(ScrabbleWordDirection direction) {
        this.direction = direction;
    }

    public String getLabel() {
        return this.word;
    }

    public boolean isOutOfGrid() {
        if (this.direction == null || this.startCell == null) {
            return false;
        }
        switch (this.direction) {
            case HORIZONTAL: {
                return this.startCell.getX() + this.word.length() > this.solution.getGridWidth();
            }
            case VERTICAL: {
                return this.startCell.getY() + this.word.length() > this.solution.getGridHeight();
            }
        }
        throw new IllegalStateException("The direction (" + (Object)((Object)this.direction) + ") is not implemented.");
    }

    public int getDistanceToCenter() {
        int y;
        int x;
        if (this.direction == null || this.startCell == null) {
            return 0;
        }
        int centerX = this.solution.getGridWidth() / 2;
        int centerY = this.solution.getGridHeight() / 2;
        switch (this.direction) {
            case HORIZONTAL: {
                x = this.startCell.getX() + this.word.length() / 2;
                y = this.startCell.getY();
                break;
            }
            case VERTICAL: {
                x = this.startCell.getX();
                y = this.startCell.getY() + this.word.length() / 2;
                break;
            }
            default: {
                throw new IllegalStateException("The direction (" + (Object)((Object)this.direction) + ") is not implemented.");
            }
        }
        return Math.abs(centerX - x) + Math.abs(centerY - y);
    }

    @Override
    public String toString() {
        return this.word;
    }
}

