/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver.ArrivalTimeUpdatingVariableListener;

@PlanningEntity
@XStreamAlias(value="VrpTimeWindowedCustomer")
public class TimeWindowedCustomer
extends Customer {
    private long readyTime;
    private long dueTime;
    private long serviceDuration;
    private Long arrivalTime;

    public long getReadyTime() {
        return this.readyTime;
    }

    public void setReadyTime(long readyTime) {
        this.readyTime = readyTime;
    }

    public long getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(long dueTime) {
        this.dueTime = dueTime;
    }

    public long getServiceDuration() {
        return this.serviceDuration;
    }

    public void setServiceDuration(long serviceDuration) {
        this.serviceDuration = serviceDuration;
    }

    @CustomShadowVariable(variableListenerClass=ArrivalTimeUpdatingVariableListener.class, sources={@PlanningVariableReference(variableName="previousStandstill")})
    public Long getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(Long arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public Long getDepartureTime() {
        if (this.arrivalTime == null) {
            return null;
        }
        return Math.max(this.arrivalTime, this.readyTime) + this.serviceDuration;
    }

    public boolean isArrivalBeforeReadyTime() {
        return this.arrivalTime != null && this.arrivalTime < this.readyTime;
    }

    public boolean isArrivalAfterDueTime() {
        return this.arrivalTime != null && this.dueTime < this.arrivalTime;
    }

    @Override
    public TimeWindowedCustomer getNextCustomer() {
        return (TimeWindowedCustomer)super.getNextCustomer();
    }

    public long getTimeWindowGapTo(TimeWindowedCustomer other) {
        long latestDepartureTime = this.dueTime + this.serviceDuration;
        long otherLatestDepartureTime = other.getDueTime() + other.getServiceDuration();
        if (latestDepartureTime < other.getReadyTime()) {
            return other.getReadyTime() - latestDepartureTime;
        }
        if (otherLatestDepartureTime < this.readyTime) {
            return this.readyTime - otherLatestDepartureTime;
        }
        return 0L;
    }
}

