/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.examples.common.persistence.AbstractPngSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.domain.location.AirLocation;
import org.optaplanner.examples.tsp.domain.location.DistanceType;
import org.optaplanner.examples.tsp.domain.location.Location;

public class TspImageStipplerImporter
extends AbstractPngSolutionImporter<TspSolution> {
    private static final double GRAY_MAXIMUM = 768.0;

    public static void main(String[] args) {
        SolutionConverter<TspSolution> converter = SolutionConverter.createImportConverter("tsp", new TspImageStipplerImporter(), TspSolution.class);
        converter.convertAll();
    }

    @Override
    public AbstractPngSolutionImporter.PngInputBuilder<TspSolution> createPngInputBuilder() {
        return new TspImageStipplerInputBuilder();
    }

    public static class TspImageStipplerInputBuilder
    extends AbstractPngSolutionImporter.PngInputBuilder<TspSolution> {
        private TspSolution tspSolution;
        private int locationListSize;

        @Override
        public TspSolution readSolution() throws IOException {
            this.tspSolution = new TspSolution();
            this.tspSolution.setId(0L);
            this.tspSolution.setName(FilenameUtils.getBaseName((String)this.inputFile.getName()));
            this.floydSteinbergDithering();
            this.createVisitList();
            BigInteger possibleSolutionSize = AbstractSolutionImporter.factorial(this.tspSolution.getLocationList().size() - 1);
            this.logger.info("TspSolution {} has {} locations with a search space of {}.", new Object[]{this.getInputId(), this.tspSolution.getLocationList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.tspSolution;
        }

        private void floydSteinbergDithering() {
            this.tspSolution.setDistanceType(DistanceType.AIR_DISTANCE);
            this.tspSolution.setDistanceUnitOfMeasurement("distance");
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            double[][] errorDiffusion = new double[width][height];
            ArrayList<Location> locationList = new ArrayList<Location>(1000);
            long id = 0L;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double error;
                    int b;
                    int g;
                    int rgb = this.image.getRGB(x, y);
                    int r = rgb & 0xFF;
                    double originalGray = (double)(r + (g = rgb >> 8 & 0xFF) + (b = rgb >> 16 & 0xFF)) / 768.0;
                    double diffusedGray = originalGray + errorDiffusion[x][y];
                    if (diffusedGray <= 0.5) {
                        AirLocation location = new AirLocation();
                        location.setId(id);
                        ++id;
                        location.setLatitude(-y);
                        location.setLongitude(x);
                        locationList.add(location);
                        error = diffusedGray;
                    } else {
                        error = diffusedGray - 1.0;
                    }
                    if (x + 1 < width) {
                        double[] dArray = errorDiffusion[x + 1];
                        int n = y;
                        dArray[n] = dArray[n] + error * 7.0 / 16.0;
                    }
                    if (y + 1 >= height) continue;
                    if (x - 1 >= 0) {
                        double[] dArray = errorDiffusion[x - 1];
                        int n = y + 1;
                        dArray[n] = dArray[n] + error * 3.0 / 16.0;
                    }
                    double[] dArray = errorDiffusion[x];
                    int n = y + 1;
                    dArray[n] = dArray[n] + error * 5.0 / 16.0;
                    if (x + 1 >= width) continue;
                    double[] dArray2 = errorDiffusion[x + 1];
                    int n2 = y + 1;
                    dArray2[n2] = dArray2[n2] + error * 1.0 / 16.0;
                }
            }
            this.tspSolution.setLocationList(locationList);
        }

        private void createVisitList() {
            List<Location> locationList = this.tspSolution.getLocationList();
            ArrayList<Visit> visitList = new ArrayList<Visit>(locationList.size() - 1);
            int count = 0;
            for (Location location : locationList) {
                if (count < 1) {
                    Domicile domicile = new Domicile();
                    domicile.setId(location.getId());
                    domicile.setLocation(location);
                    this.tspSolution.setDomicile(domicile);
                } else {
                    Visit visit = new Visit();
                    visit.setId(location.getId());
                    visit.setLocation(location);
                    visitList.add(visit);
                }
                ++count;
            }
            this.tspSolution.setVisitList(visitList);
        }
    }
}

