/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.score;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;

public class NQueensAdvancedIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<NQueens> {
    private Map<Integer, List<Queen>> rowIndexMap;
    private Map<Integer, List<Queen>> ascendingDiagonalIndexMap;
    private Map<Integer, List<Queen>> descendingDiagonalIndexMap;
    private int score;

    public void resetWorkingSolution(NQueens nQueens) {
        int n = nQueens.getN();
        this.rowIndexMap = new HashMap<Integer, List<Queen>>(n);
        this.ascendingDiagonalIndexMap = new HashMap<Integer, List<Queen>>(n * 2);
        this.descendingDiagonalIndexMap = new HashMap<Integer, List<Queen>>(n * 2);
        for (int i = 0; i < n; ++i) {
            this.rowIndexMap.put(i, new ArrayList(n));
            this.ascendingDiagonalIndexMap.put(i, new ArrayList(n));
            this.descendingDiagonalIndexMap.put(i, new ArrayList(n));
            if (i == 0) continue;
            this.ascendingDiagonalIndexMap.put(n - 1 + i, new ArrayList(n));
            this.descendingDiagonalIndexMap.put(-i, new ArrayList(n));
        }
        this.score = 0;
        for (Queen queen : nQueens.getQueenList()) {
            this.insert(queen);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((Queen)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((Queen)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((Queen)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((Queen)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(Queen queen) {
        Row row = queen.getRow();
        if (row != null) {
            int rowIndex = queen.getRowIndex();
            List<Queen> rowIndexList = this.rowIndexMap.get(rowIndex);
            this.score -= rowIndexList.size();
            rowIndexList.add(queen);
            List<Queen> ascendingDiagonalIndexList = this.ascendingDiagonalIndexMap.get(queen.getAscendingDiagonalIndex());
            this.score -= ascendingDiagonalIndexList.size();
            ascendingDiagonalIndexList.add(queen);
            List<Queen> descendingDiagonalIndexList = this.descendingDiagonalIndexMap.get(queen.getDescendingDiagonalIndex());
            this.score -= descendingDiagonalIndexList.size();
            descendingDiagonalIndexList.add(queen);
        }
    }

    private void retract(Queen queen) {
        Row row = queen.getRow();
        if (row != null) {
            List<Queen> rowIndexList = this.rowIndexMap.get(queen.getRowIndex());
            rowIndexList.remove(queen);
            this.score += rowIndexList.size();
            List<Queen> ascendingDiagonalIndexList = this.ascendingDiagonalIndexMap.get(queen.getAscendingDiagonalIndex());
            ascendingDiagonalIndexList.remove(queen);
            this.score += ascendingDiagonalIndexList.size();
            List<Queen> descendingDiagonalIndexList = this.descendingDiagonalIndexMap.get(queen.getDescendingDiagonalIndex());
            descendingDiagonalIndexList.remove(queen);
            this.score += descendingDiagonalIndexList.size();
        }
    }

    public SimpleScore calculateScore() {
        return SimpleScore.valueOf((int)this.score);
    }
}

