/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.solver;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Test;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.meetingscheduling.domain.Day;
import org.optaplanner.examples.meetingscheduling.domain.Meeting;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.MeetingParametrization;
import org.optaplanner.examples.meetingscheduling.domain.MeetingSchedule;
import org.optaplanner.examples.meetingscheduling.domain.Person;
import org.optaplanner.examples.meetingscheduling.domain.RequiredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;
import org.optaplanner.test.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreVerifier;

public class MeetingSchedulingScoreConstraintTest {
    private HardMediumSoftScoreVerifier<MeetingSchedule> scoreVerifier = new HardMediumSoftScoreVerifier(SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/meetingscheduling/solver/meetingSchedulingSolverConfig.xml"));

    private MeetingSchedule getMeetingSchedule(int numberOfEntities) {
        MeetingSchedule solution = new MeetingSchedule();
        MeetingParametrization parametrization = new MeetingParametrization();
        parametrization.setId(Long.valueOf(0L));
        solution.setParametrization(parametrization);
        ArrayList<Meeting> meetingList = new ArrayList<Meeting>();
        ArrayList<Day> dayList = new ArrayList<Day>();
        ArrayList<TimeGrain> timeGrainList = new ArrayList<TimeGrain>();
        ArrayList<Room> roomList = new ArrayList<Room>();
        ArrayList<Person> personList = new ArrayList<Person>();
        ArrayList<MeetingAssignment> meetingAssignmentList = new ArrayList<MeetingAssignment>();
        for (int i = 0; i < numberOfEntities; ++i) {
            Meeting m = new Meeting();
            m.setId(Long.valueOf(i));
            m.setTopic("meeting" + i);
            meetingList.add(m);
            Day d = new Day();
            d.setId(Long.valueOf(i));
            d.setDayOfYear(i + 1);
            dayList.add(d);
            TimeGrain t = new TimeGrain();
            t.setId(Long.valueOf(i));
            t.setGrainIndex(i);
            t.setDay((Day)dayList.get(0));
            t.setStartingMinuteOfDay(i * 15);
            timeGrainList.add(t);
            Room r = new Room();
            r.setId(Long.valueOf(i));
            r.setName("room" + i);
            roomList.add(r);
            Person p = new Person();
            p.setId(Long.valueOf(i));
            p.setFullName("person" + i);
            personList.add(p);
            MeetingAssignment ma = new MeetingAssignment();
            ma.setId(Long.valueOf(i));
            meetingAssignmentList.add(ma);
        }
        solution.setRoomList(roomList);
        solution.setTimeGrainList(timeGrainList);
        solution.setDayList(dayList);
        solution.setPersonList(personList);
        solution.setMeetingList(meetingList);
        solution.setMeetingAssignmentList(meetingAssignmentList);
        return solution;
    }

    @Test
    public void roomStability() {
        MeetingSchedule solution = this.getMeetingSchedule(6);
        MeetingParametrization parametrization = solution.getParametrization();
        ArrayList<RequiredAttendance> aList = new ArrayList<RequiredAttendance>();
        for (int i = 0; i < solution.getMeetingList().size(); ++i) {
            Meeting m = (Meeting)solution.getMeetingList().get(i);
            m.setDurationInGrains(2);
            ((MeetingAssignment)solution.getMeetingAssignmentList().get(i)).setMeeting(m);
            RequiredAttendance ra = new RequiredAttendance();
            ra.setId(Long.valueOf(i));
            ra.setPerson((Person)solution.getPersonList().get(0));
            ra.setMeeting(m);
            aList.add(ra);
            m.setPreferredAttendanceList(new ArrayList());
            m.setRequiredAttendanceList(Collections.singletonList(ra));
        }
        solution.setAttendanceList(aList);
        MeetingAssignment ma0 = (MeetingAssignment)solution.getMeetingAssignmentList().get(0);
        ma0.setStartingTimeGrain((TimeGrain)solution.getTimeGrainList().get(0));
        ma0.setRoom((Room)solution.getRoomList().get(0));
        MeetingAssignment ma1 = (MeetingAssignment)solution.getMeetingAssignmentList().get(1);
        ma1.setStartingTimeGrain((TimeGrain)solution.getTimeGrainList().get(2));
        ma1.setRoom((Room)solution.getRoomList().get(1));
        this.scoreVerifier.assertSoftWeight("Room stability", -parametrization.getRoomStability(), (Object)solution);
        ma1.setStartingTimeGrain((TimeGrain)solution.getTimeGrainList().get(3));
        this.scoreVerifier.assertSoftWeight("Room stability", -parametrization.getRoomStability(), (Object)solution);
        ma1.setStartingTimeGrain((TimeGrain)solution.getTimeGrainList().get(4));
        this.scoreVerifier.assertSoftWeight("Room stability", -parametrization.getRoomStability(), (Object)solution);
        ma1.setStartingTimeGrain((TimeGrain)solution.getTimeGrainList().get(5));
        this.scoreVerifier.assertSoftWeight("Room stability", 0, (Object)solution);
        ma1.setStartingTimeGrain((TimeGrain)solution.getTimeGrainList().get(2));
        ma1.setRoom((Room)solution.getRoomList().get(0));
        this.scoreVerifier.assertSoftWeight("Room stability", 0, (Object)solution);
        ma1.setRoom((Room)solution.getRoomList().get(1));
        MeetingAssignment ma2 = (MeetingAssignment)solution.getMeetingAssignmentList().get(2);
        ma2.setStartingTimeGrain((TimeGrain)solution.getTimeGrainList().get(4));
        ma2.setRoom((Room)solution.getRoomList().get(0));
        this.scoreVerifier.assertSoftWeight("Room stability", -parametrization.getRoomStability() * 2, (Object)solution);
    }
}

