/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceParametrization;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.examples.conferencescheduling.persistence.ConnectionFollowRedirects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConferenceSchedulingCfpDevoxxImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConferenceSchedulingCfpDevoxxImporter.class);
    private static final String ZONE_ID = "Europe/Paris";
    private static final String[] SMALL_ROOMS_TYPE_NAMES = new String[]{"lab", "bof"};
    private static final String[] LARGE_ROOMS_TYPE_NAMES = new String[]{"tia", "uni", "conf", "Deep Dive", "Opening Keynote", "Closing Keynote", "Quickie Sessions", "quick"};
    private static final String[] IGNORED_TALK_TYPES = new String[]{"ignite", "key"};
    private static final String[] IGNORED_ROOM_IDS = new String[]{"ExhibitionHall"};
    private static final String[] IGNORED_SPEAKER_NAMES = new String[]{"Devoxx Partner"};
    private String conferenceBaseUrl;
    private Map<String, TalkType> talkTypeNameToTalkTypeMap;
    private Map<String, Room> roomIdToRoomMap;
    private Map<String, Speaker> speakerNameToSpeakerMap;
    private Map<String, Talk> talkCodeToTalkMap;
    private Set<String> talkUrlSet;
    private Set<String> trackIdSet;
    private ConferenceSolution solution;
    private Map<String, Integer> timeslotTalkTypeToTotalMap = new HashMap<String, Integer>();
    private Map<String, Integer> talkTalkTypeToTotalMap = new HashMap<String, Integer>();

    public ConferenceSchedulingCfpDevoxxImporter(String conferenceBaseUrl) {
        this.conferenceBaseUrl = conferenceBaseUrl;
    }

    public ConferenceSolution importSolution() {
        this.solution = new ConferenceSolution();
        this.solution.setId(0L);
        this.solution.setConferenceName(this.getConferenceName());
        ConferenceParametrization parametrization = new ConferenceParametrization();
        parametrization.setId(0L);
        this.solution.setParametrization(parametrization);
        this.importTalkTypeList();
        this.importTrackIdSet();
        this.importRoomList();
        this.importSpeakerList();
        this.importTalkList();
        this.importTimeslotList();
        for (TalkType talkType : this.solution.getTalkTypeList()) {
            LOGGER.info(talkType.getName() + ": Timeslots Total is " + (this.timeslotTalkTypeToTotalMap.get(talkType.getName()) == null ? 0 : this.timeslotTalkTypeToTotalMap.get(talkType.getName())) + ", Talks Total is " + (this.talkTalkTypeToTotalMap.get(talkType.getName()) == null ? 0 : this.talkTalkTypeToTotalMap.get(talkType.getName())));
        }
        return this.solution;
    }

    private String getConferenceName() {
        LOGGER.debug("Sending a request to: " + this.conferenceBaseUrl);
        JsonObject conferenceObject = this.readJson(this.conferenceBaseUrl, JsonReader::readObject);
        return conferenceObject.getString("eventCode");
    }

    private void importTalkTypeList() {
        this.talkTypeNameToTalkTypeMap = new HashMap<String, TalkType>();
        ArrayList<TalkType> talkTypeList = new ArrayList<TalkType>();
        String proposalTypeUrl = this.conferenceBaseUrl + "/proposalTypes";
        LOGGER.debug("Sending a request to: " + proposalTypeUrl);
        JsonObject rootObject = this.readJson(proposalTypeUrl, JsonReader::readObject);
        JsonArray talkTypeArray = rootObject.getJsonArray("proposalTypes");
        for (int i = 0; i < talkTypeArray.size(); ++i) {
            JsonObject talkTypeObject = talkTypeArray.getJsonObject(i);
            String talkTypeName = talkTypeObject.getString("id");
            if (this.talkTypeNameToTalkTypeMap.keySet().contains(talkTypeName)) {
                LOGGER.warn("Duplicate talk type in " + proposalTypeUrl + " at index " + i + ".");
                continue;
            }
            TalkType talkType = new TalkType(i, talkTypeName);
            talkType.setCompatibleRoomSet(new HashSet<Room>());
            talkType.setCompatibleTimeslotSet(new HashSet<Timeslot>());
            talkTypeList.add(talkType);
            this.talkTypeNameToTalkTypeMap.put(talkTypeName, talkType);
        }
        this.solution.setTalkTypeList(talkTypeList);
    }

    private void importTrackIdSet() {
        this.trackIdSet = new HashSet<String>();
        String tracksUrl = this.conferenceBaseUrl + "/tracks";
        LOGGER.debug("Sending a request to: " + tracksUrl);
        JsonObject rootObject = this.readJson(tracksUrl, JsonReader::readObject);
        JsonArray tracksArray = rootObject.getJsonArray("tracks");
        for (int i = 0; i < tracksArray.size(); ++i) {
            this.trackIdSet.add(tracksArray.getJsonObject(i).getString("id"));
        }
    }

    private void importRoomList() {
        this.roomIdToRoomMap = new HashMap<String, Room>();
        ArrayList<Room> roomList = new ArrayList<Room>();
        String roomsUrl = this.conferenceBaseUrl + "/rooms/";
        LOGGER.debug("Sending a request to: " + roomsUrl);
        JsonObject rootObject = this.readJson(roomsUrl, JsonReader::readObject);
        JsonArray roomArray = rootObject.getJsonArray("rooms");
        for (int i = 0; i < roomArray.size(); ++i) {
            JsonObject roomObject = roomArray.getJsonObject(i);
            String id = roomObject.getString("id");
            int capacity = roomObject.getInt("capacity");
            if (Arrays.asList(IGNORED_ROOM_IDS).contains(id)) continue;
            Room room = new Room(i);
            room.setName(id);
            room.setCapacity(capacity);
            room.setTalkTypeSet(this.getTalkTypeSetForCapacity(capacity));
            for (TalkType talkType : room.getTalkTypeSet()) {
                talkType.getCompatibleRoomSet().add(room);
            }
            room.setTagSet(new HashSet<String>());
            room.setUnavailableTimeslotSet(new HashSet<Timeslot>());
            roomList.add(room);
            this.roomIdToRoomMap.put(id, room);
        }
        roomList.sort(Comparator.comparing(Room::getName));
        this.solution.setRoomList(roomList);
    }

    private void importSpeakerList() {
        this.speakerNameToSpeakerMap = new HashMap<String, Speaker>();
        this.talkUrlSet = new HashSet<String>();
        ArrayList<Speaker> speakerList = new ArrayList<Speaker>();
        String speakersUrl = this.conferenceBaseUrl + "/speakers";
        LOGGER.debug("Sending a request to: " + speakersUrl);
        JsonArray speakerArray = this.readJson(speakersUrl, JsonReader::readArray);
        for (int i = 0; i < speakerArray.size(); ++i) {
            String speakerUrl = speakerArray.getJsonObject(i).getJsonArray("links").getJsonObject(0).getString("href");
            LOGGER.debug("Sending a request to: " + speakerUrl);
            JsonObject speakerObject = this.readJson(speakerUrl, JsonReader::readObject);
            String speakerId = speakerObject.getString("uuid");
            String speakerName = speakerObject.getString("firstName") + " " + speakerObject.getString("lastName");
            if (Arrays.asList(IGNORED_SPEAKER_NAMES).contains(speakerName)) continue;
            Speaker speaker = new Speaker(i);
            speaker.setName(speakerName);
            speaker.withPreferredRoomTagSet(new HashSet<String>()).withPreferredTimeslotTagSet(new HashSet<String>()).withProhibitedRoomTagSet(new HashSet<String>()).withProhibitedTimeslotTagSet(new HashSet<String>()).withRequiredRoomTagSet(new HashSet<String>()).withRequiredTimeslotTagSet(new HashSet<String>()).withUnavailableTimeslotSet(new HashSet<Timeslot>()).withUndesiredRoomTagSet(new HashSet<String>()).withUndesiredTimeslotTagSet(new HashSet<String>());
            speakerList.add(speaker);
            if (this.speakerNameToSpeakerMap.keySet().contains(speakerName)) {
                throw new IllegalStateException("Speaker (" + speakerName + ") with id (" + speakerId + ") already exists in the speaker list");
            }
            this.speakerNameToSpeakerMap.put(speakerName, speaker);
            JsonArray speakerTalksArray = speakerObject.getJsonArray("acceptedTalks");
            for (int j = 0; j < speakerTalksArray.size(); ++j) {
                String talkUrl = speakerTalksArray.getJsonObject(j).getJsonArray("links").getJsonObject(0).getString("href");
                this.talkUrlSet.add(talkUrl);
            }
        }
        speakerList.sort(Comparator.comparing(Speaker::getName));
        this.solution.setSpeakerList(speakerList);
    }

    private void importTalkList() {
        String[] confFiles;
        this.talkCodeToTalkMap = new HashMap<String, Talk>();
        ArrayList<Talk> talkList = new ArrayList<Talk>();
        Long talkId = 0L;
        String talksPath = this.getClass().getResource("devoxxBE").toString();
        for (String confType : confFiles = new String[]{"BOF", "Conf14Sept2018", "DeepDive", "HandsOnLabs", "Quickies", "ToolsInAction"}) {
            LOGGER.debug("Sending a request to: " + talksPath + "/" + confType + ".json");
            JsonArray talksArray = this.readJson(talksPath + "/" + confType + ".json", JsonReader::readObject).getJsonObject("approvedTalks").getJsonArray("talks");
            for (int i = 0; i < talksArray.size(); ++i) {
                JsonObject talkObject = talksArray.getJsonObject(i);
                String code = talkObject.getString("id");
                String title = talkObject.getString("title").substring(5);
                String talkTypeName = talkObject.getJsonObject("talkType").getString("id");
                Set<String> themeTrackSet = this.extractThemeTrackSet(talkObject, code, title);
                String language = talkObject.getString("lang");
                int audienceLevel = Integer.parseInt(talkObject.getString("audienceLevel").replaceAll("[^0-9]", ""));
                List<Speaker> speakerList = this.extractSpeakerList(confType, talkObject, code, title);
                Set<String> contentTagSet = this.extractContentTagSet(talkObject);
                String state = talkObject.getJsonObject("state").getString("code");
                if (Arrays.asList(IGNORED_TALK_TYPES).contains(code) || state.equals("declined")) continue;
                Long l = talkId;
                Long l2 = talkId = Long.valueOf(talkId + 1L);
                Talk talk = this.createTalk(l, code, title, talkTypeName, themeTrackSet, language, speakerList, audienceLevel, contentTagSet);
                this.talkCodeToTalkMap.put(code, talk);
                talkList.add(talk);
                this.talkTalkTypeToTotalMap.merge(talkTypeName, 1, Integer::sum);
            }
        }
        this.solution.setTalkList(talkList);
    }

    private Set<String> extractThemeTrackSet(JsonObject talkObject, String code, String title) {
        HashSet<String> themeTrackSet = new HashSet<String>(Arrays.asList(talkObject.getJsonObject("track").getString("id")));
        if (!this.trackIdSet.containsAll(themeTrackSet)) {
            throw new IllegalStateException("The talk (" + title + ") with id (" + code + ") contains trackId + (" + this.trackIdSet + ") that doesn't exist in the trackIdSet.");
        }
        return themeTrackSet;
    }

    private List<Speaker> extractSpeakerList(String confType, JsonObject talkObject, String code, String title) {
        ArrayList<Speaker> speakerList = new ArrayList<Speaker>();
        String mainSpeakerName = talkObject.getString("mainSpeaker");
        if (Arrays.asList(IGNORED_SPEAKER_NAMES).contains(mainSpeakerName)) {
            return speakerList;
        }
        speakerList.add(this.getSpeakerOrCreateOneIfNull(confType, code, title, mainSpeakerName));
        if (talkObject.containsKey((Object)"secondarySpeaker")) {
            String secondarySpeakerName = talkObject.getString("secondarySpeaker");
            speakerList.add(this.getSpeakerOrCreateOneIfNull(confType, code, title, secondarySpeakerName));
        }
        if (talkObject.containsKey((Object)"otherSpeakers")) {
            JsonArray otherSpeakersArray = talkObject.getJsonArray("otherSpeakers");
            for (JsonValue otherSpeakerName : otherSpeakersArray) {
                speakerList.add(this.getSpeakerOrCreateOneIfNull(confType, code, title, otherSpeakerName.toString().replaceAll("\"", "")));
            }
        }
        return speakerList;
    }

    private Speaker getSpeakerOrCreateOneIfNull(String confType, String code, String title, String speakerName) {
        Speaker speaker = this.speakerNameToSpeakerMap.get(speakerName);
        if (speaker == null) {
            LOGGER.warn("The talk (" + code + ": " + title + ") of type ( " + confType + ") has a speaker (" + speakerName + ") that doesn't exist in speaker list.");
            speaker = new Speaker(this.solution.getSpeakerList().size());
            speaker.setName(speakerName);
            speaker.withPreferredRoomTagSet(new HashSet<String>()).withPreferredTimeslotTagSet(new HashSet<String>()).withProhibitedRoomTagSet(new HashSet<String>()).withProhibitedTimeslotTagSet(new HashSet<String>()).withRequiredRoomTagSet(new HashSet<String>()).withRequiredTimeslotTagSet(new HashSet<String>()).withUnavailableTimeslotSet(new HashSet<Timeslot>()).withUndesiredRoomTagSet(new HashSet<String>()).withUndesiredTimeslotTagSet(new HashSet<String>());
            if (this.speakerNameToSpeakerMap.keySet().contains(speakerName)) {
                throw new IllegalStateException("Speaker (" + speakerName + ") already exists in the speaker list");
            }
            this.speakerNameToSpeakerMap.put(speakerName, speaker);
            this.solution.getSpeakerList().add(speaker);
        }
        return speaker;
    }

    private Set<String> extractContentTagSet(JsonObject talkObject) {
        if (talkObject.containsKey((Object)"tags")) {
            return talkObject.getJsonArray("tags").stream().map(JsonObject.class::cast).filter(tagObject -> !tagObject.getString("value").isEmpty()).map(tagObject -> tagObject.getString("value")).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private Talk createTalk(Long talkId, String code, String title, String talkTypeName, Set<String> themeTrackSet, String languageg, List<Speaker> speakerList, int audienceLevel, Set<String> contentTagSet) {
        Talk talk = new Talk(talkId);
        talk.setCode(code);
        talk.setTitle(title);
        if (this.talkTypeNameToTalkTypeMap.get(talkTypeName) == null) {
            throw new IllegalStateException("The talk (" + title + ") with id (" + code + ") has a talkType (" + talkTypeName + ") that doesn't exist in the talkType list.");
        }
        talk.setTalkType(this.talkTypeNameToTalkTypeMap.get(talkTypeName));
        talk.withThemeTrackTagSet(themeTrackSet).withLanguage(languageg).withSpeakerList(speakerList).withAudienceLevel(audienceLevel).withAudienceTypeSet(new HashSet<String>()).withContentTagSet(contentTagSet).withPreferredRoomTagSet(new HashSet<String>()).withPreferredTimeslotTagSet(new HashSet<String>()).withProhibitedRoomTagSet(new HashSet<String>()).withProhibitedTimeslotTagSet(new HashSet<String>()).withRequiredRoomTagSet(new HashSet<String>()).withRequiredTimeslotTagSet(new HashSet<String>()).withSectorTagSet(new HashSet<String>()).withUndesiredRoomTagSet(new HashSet<String>()).withUndesiredTimeslotTagSet(new HashSet<String>()).withMutuallyExclusiveTalksTagSet(new HashSet<String>()).withPrerequisiteTalksCodesSet(new HashSet<Talk>());
        if (talk.getContentTagSet().contains("Devoxx Sponsor")) {
            talk.getMutuallyExclusiveTalksTagSet().add("Devoxx Sponsor");
        }
        return talk;
    }

    private void importTimeslotList() {
        ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>();
        HashMap<Timeslot, ArrayList<Room>> timeslotToAvailableRoomsMap = new HashMap<Timeslot, ArrayList<Room>>();
        HashMap<Pair, Timeslot> startAndEndTimeToTimeslotMap = new HashMap<Pair, Timeslot>();
        Long timeSlotId = 0L;
        String schedulesUrl = this.conferenceBaseUrl + "/schedules/";
        LOGGER.debug("Sending a request to: " + schedulesUrl);
        JsonArray daysArray = this.readJson(schedulesUrl, JsonReader::readObject).getJsonArray("links");
        for (int i = 0; i < daysArray.size(); ++i) {
            JsonObject dayObject = daysArray.getJsonObject(i);
            String dayUrl = dayObject.getString("href");
            LOGGER.debug("Sending a request to: " + dayUrl);
            JsonArray daySlotsArray = this.readJson(dayUrl, JsonReader::readObject).getJsonArray("slots");
            for (int j = 0; j < daySlotsArray.size(); ++j) {
                Timeslot timeslot2;
                JsonObject timeslotObject = daySlotsArray.getJsonObject(j);
                LocalDateTime startDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeslotObject.getJsonNumber("fromTimeMillis").longValue()), ZoneId.of(ZONE_ID));
                LocalDateTime endDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeslotObject.getJsonNumber("toTimeMillis").longValue()), ZoneId.of(ZONE_ID));
                Room room = this.roomIdToRoomMap.get(timeslotObject.getString("roomId"));
                if (room == null) {
                    throw new IllegalStateException("The timeslot (" + timeslotObject.getString("slotId") + ") has a roomId (" + timeslotObject.getString("roomId") + ") that does not exist in the rooms list");
                }
                String talkTypeName = timeslotObject.getString("slotId").split("_")[0];
                TalkType timeslotTalkType = this.talkTypeNameToTalkTypeMap.get(talkTypeName);
                if (Arrays.asList(IGNORED_TALK_TYPES).contains(talkTypeName)) continue;
                if (startAndEndTimeToTimeslotMap.keySet().contains(Pair.of((Object)startDateTime, (Object)endDateTime))) {
                    timeslot2 = (Timeslot)startAndEndTimeToTimeslotMap.get(Pair.of((Object)startDateTime, (Object)endDateTime));
                    ((List)timeslotToAvailableRoomsMap.get(timeslot2)).add(room);
                    if (timeslotTalkType != null) {
                        timeslot2.getTalkTypeSet().add(timeslotTalkType);
                    }
                } else {
                    Long l = timeSlotId;
                    Long l2 = timeSlotId = Long.valueOf(timeSlotId + 1L);
                    timeslot2 = new Timeslot(l);
                    timeslot2.withStartDateTime(startDateTime).withEndDateTime(endDateTime).withTalkTypeSet(timeslotTalkType == null ? new HashSet<TalkType>() : new HashSet<TalkType>(Arrays.asList(timeslotTalkType)));
                    timeslot2.setTagSet(new HashSet<String>());
                    timeslotList.add(timeslot2);
                    timeslotToAvailableRoomsMap.put(timeslot2, new ArrayList<Room>(Arrays.asList(room)));
                    startAndEndTimeToTimeslotMap.put(Pair.of((Object)startDateTime, (Object)endDateTime), timeslot2);
                }
                if (!timeslotObject.isNull("talk")) {
                    this.scheduleTalk(timeslotObject, room, timeslot2);
                }
                for (TalkType talkType : timeslot2.getTalkTypeSet()) {
                    talkType.getCompatibleTimeslotSet().add(timeslot2);
                }
                this.timeslotTalkTypeToTotalMap.merge(talkTypeName, 1, Integer::sum);
            }
        }
        for (Room room : this.solution.getRoomList()) {
            room.setUnavailableTimeslotSet(timeslotList.stream().filter(timeslot -> !((List)timeslotToAvailableRoomsMap.get(timeslot)).contains(room)).collect(Collectors.toSet()));
        }
        this.solution.setTimeslotList(timeslotList);
    }

    private Set<TalkType> getTalkTypeSetForCapacity(int capacity) {
        HashSet<TalkType> talkTypeSet = new HashSet<TalkType>();
        ArrayList<String> typeNames = new ArrayList<String>();
        if (capacity < 100) {
            typeNames.addAll(Arrays.asList(SMALL_ROOMS_TYPE_NAMES));
        } else {
            typeNames.addAll(Arrays.asList(LARGE_ROOMS_TYPE_NAMES));
        }
        for (String talkTypeName : typeNames) {
            TalkType talkType = this.talkTypeNameToTalkTypeMap.get(talkTypeName);
            if (talkType == null) continue;
            talkTypeSet.add(talkType);
        }
        return talkTypeSet;
    }

    private void scheduleTalk(JsonObject timeslotObject, Room room, Timeslot timeslot) {
        Talk talk = this.talkCodeToTalkMap.get(timeslotObject.getJsonObject("talk").getString("id"));
        if (talk == null) {
            throw new IllegalStateException("The timeslot (" + timeslotObject.getString("slotId") + ") has a talk (" + timeslotObject.getJsonObject("talk").getString("id") + ") that does not exist in the talk list");
        }
        if (talk.isPinnedByUser()) {
            throw new IllegalStateException("The timeslot (" + timeslotObject.getString("slotId") + ") has a talk (" + timeslotObject.getJsonObject("talk").getString("id") + ") that is already pinned by user at another timeslot (" + talk.getTimeslot().toString() + ").");
        }
        talk.setRoom(room);
        talk.setTimeslot(timeslot);
        talk.setPinnedByUser(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R readJson(String url, Function<JsonReader, R> mapper) {
        try (InputStream inputStream = new ConnectionFollowRedirects(url).getInputStream();){
            JsonReader jsonReader = Json.createReader((InputStream)inputStream);
            R r = mapper.apply(jsonReader);
            return r;
        }
        catch (IOException e) {
            throw new IllegalStateException("Import failed on URL (" + url + ").", e);
        }
    }
}

