/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.swingui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingCfpDevoxxImporter;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingXlsxFileIO;

public class ConferenceSchedulingPanel
extends SolutionPanel<ConferenceSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/conferencescheduling/swingui/conferenceSchedulingLogo.png";

    public ConferenceSchedulingPanel() {
        JButton importConferenceButton = new JButton("Import conference");
        importConferenceButton.addActionListener(event -> {
            ConferenceSchedulingCfpDevoxxImporter conferenceSchedulingImporter = new ConferenceSchedulingCfpDevoxxImporter("https://dvbe18.confinabox.com/api/conferences/DVBE18");
            this.solutionBusiness.setSolution(conferenceSchedulingImporter.importSolution());
        });
        JButton publishButton = new JButton("Publish");
        publishButton.addActionListener(actionEvent -> ((ConferenceSolution)this.solutionBusiness.getSolution()).getTalkList().stream().forEach(talk -> {
            talk.setPublishedTimeslot(talk.getTimeslot());
            talk.setPublishedRoom(talk.getRoom());
        }));
        JButton button = new JButton("Show in LibreOffice or Excel");
        button.addActionListener(event -> {
            File tempFile;
            ConferenceSchedulingXlsxFileIO solutionFileIO = new ConferenceSchedulingXlsxFileIO();
            try {
                tempFile = File.createTempFile(this.solutionBusiness.getSolutionFileName(), "." + solutionFileIO.getOutputFileExtension());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create temp file.", e);
            }
            solutionFileIO.write(this.solutionBusiness.getSolution(), tempFile);
            try {
                Desktop.getDesktop().open(tempFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to show temp file (" + tempFile + ") in LibreOffice or Excel.", e);
            }
        });
        this.add(importConferenceButton);
        this.add(publishButton);
        this.add(button);
        this.add(new JLabel("Changes to that file are ignored unless you explicitly save it there and open it here."));
    }

    @Override
    public void resetPanel(ConferenceSolution solution) {
    }
}

