/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.solver.score;

import java.util.HashSet;
import java.util.List;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;

public class TspEasyScoreCalculator
implements EasyScoreCalculator<TspSolution> {
    public SimpleLongScore calculateScore(TspSolution tspSolution) {
        List<Visit> visitList = tspSolution.getVisitList();
        HashSet<Visit> tailVisitSet = new HashSet<Visit>(visitList);
        long score = 0L;
        for (Visit visit : visitList) {
            Standstill previousStandstill = visit.getPreviousStandstill();
            if (previousStandstill == null) continue;
            score -= visit.getDistanceFromPreviousStandstill();
            if (!(previousStandstill instanceof Visit)) continue;
            tailVisitSet.remove(previousStandstill);
        }
        Domicile domicile = tspSolution.getDomicile();
        for (Visit tailVisit : tailVisitSet) {
            if (tailVisit.getPreviousStandstill() == null) continue;
            score -= tailVisit.getDistanceTo(domicile);
        }
        return SimpleLongScore.valueOf((long)score);
    }
}

