/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;

@XStreamAlias(value="MsDay")
public class Day
extends AbstractPersistable
implements Labeled {
    private int dayOfYear;
    private static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("E", Locale.ENGLISH);

    public int getDayOfYear() {
        return this.dayOfYear;
    }

    public void setDayOfYear(int dayOfYear) {
        this.dayOfYear = dayOfYear;
    }

    public String getDateString() {
        return DAY_FORMATTER.format(this.toDate());
    }

    public LocalDate toDate() {
        return LocalDate.ofYearDay(LocalDate.now().getYear(), this.dayOfYear);
    }

    @Override
    public String getLabel() {
        return this.getDateString();
    }

    @Override
    public String toString() {
        return this.getDateString();
    }
}

