/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.SolveAllTurtleTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class UnsolvedDirSolveAllTurtleTest<Solution_>
extends SolveAllTurtleTest<Solution_> {
    protected final CommonApp<Solution_> commonApp;
    protected final File dataFile;
    protected SolutionFileIO<Solution_> solutionFileIO;

    protected static <Solution_> List<Object[]> getUnsolvedDirFilesAsParameters(CommonApp<Solution_> commonApp) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        String inputFileExtension = commonApp.createSolutionFileIO().getInputFileExtension();
        ArrayList fileList = new ArrayList(FileUtils.listFiles((File)unsolvedDataDir, (String[])new String[]{inputFileExtension}, (boolean)true));
        fileList.sort(new ProblemFileComparator());
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected UnsolvedDirSolveAllTurtleTest(CommonApp<Solution_> commonApp, File dataFile) {
        super(commonApp.getSolverConfig());
        this.commonApp = commonApp;
        this.dataFile = dataFile;
    }

    @Before
    public void setUp() {
        this.solutionFileIO = this.commonApp.createSolutionFileIO();
    }

    @Override
    protected Solution_ readProblem() {
        Object problem = this.solutionFileIO.read(this.dataFile);
        this.logger.info("Opened: {}", (Object)this.dataFile);
        return (Solution_)problem;
    }
}

