/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.Period;

@XStreamAlias(value="Day")
public class Day
extends AbstractPersistable {
    private static final String[] WEEKDAYS = new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sat", "Sun"};
    private int dayIndex;
    private List<Period> periodList;

    public int getDayIndex() {
        return this.dayIndex;
    }

    public void setDayIndex(int dayIndex) {
        this.dayIndex = dayIndex;
    }

    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    public String getLabel() {
        String weekday = WEEKDAYS[this.dayIndex % WEEKDAYS.length];
        if (this.dayIndex > WEEKDAYS.length) {
            return "Day " + this.dayIndex;
        }
        return weekday;
    }

    @Override
    public String toString() {
        return Integer.toString(this.dayIndex);
    }
}

