/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Collections;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintType;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.LoggingTest;

public abstract class PlannerBenchmarkTest
extends LoggingTest {
    private static final long WARM_UP_SECONDS_SPENT = 2L;
    private static final long MAXIMUM_SECONDS_SPENT = 8L;

    protected abstract String createSolverConfigResource();

    protected PlannerBenchmarkFactory buildPlannerBenchmarkFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.createSolverConfigResource());
        File benchmarkDirectory = new File("target/test/data");
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverFactory((SolverFactory)solverFactory, (File)benchmarkDirectory);
        PlannerBenchmarkConfig plannerBenchmarkConfig = benchmarkFactory.getPlannerBenchmarkConfig();
        plannerBenchmarkConfig.setWarmUpSecondsSpentLimit(Long.valueOf(2L));
        plannerBenchmarkConfig.setSolverBenchmarkConfigList(Collections.emptyList());
        plannerBenchmarkConfig.setSolverBenchmarkBluePrintConfigList(Collections.singletonList(new SolverBenchmarkBluePrintConfig().withSolverBenchmarkBluePrintType(SolverBenchmarkBluePrintType.CONSTRUCTION_HEURISTIC_WITH_AND_WITHOUT_LOCAL_SEARCH)));
        long maximumSecondsSpentPerSolverBenchmark = 4L;
        SolverBenchmarkConfig inheritedSolverBenchmarkConfig = plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig();
        inheritedSolverBenchmarkConfig.getSolverConfig().setTerminationConfig(new TerminationConfig().withSecondsSpentLimit(Long.valueOf(maximumSecondsSpentPerSolverBenchmark)));
        return benchmarkFactory;
    }
}

