/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class CloudBalancingGenerator
extends LoggingMain {
    private static final Price[] CPU_POWER_PRICES = new Price[]{new Price(3, "single core 3ghz", 110), new Price(4, "dual core 2ghz", 140), new Price(6, "dual core 3ghz", 180), new Price(8, "quad core 2ghz", 270), new Price(12, "quad core 3ghz", 400), new Price(16, "quad core 4ghz", 1000), new Price(24, "eight core 3ghz", 3000)};
    private static final Price[] MEMORY_PRICES = new Price[]{new Price(2, "2 gigabyte", 140), new Price(4, "4 gigabyte", 180), new Price(8, "8 gigabyte", 220), new Price(16, "16 gigabyte", 300), new Price(32, "32 gigabyte", 400), new Price(64, "64 gigabyte", 600), new Price(96, "96 gigabyte", 1000)};
    private static final Price[] NETWORK_BANDWIDTH_PRICES = new Price[]{new Price(2, "2 gigabyte", 100), new Price(4, "4 gigabyte", 200), new Price(6, "6 gigabyte", 300), new Price(8, "8 gigabyte", 400), new Price(12, "12 gigabyte", 600), new Price(16, "16 gigabyte", 800), new Price(20, "20 gigabyte", 1000)};
    private static final int MAXIMUM_REQUIRED_CPU_POWER = 12;
    private static final int MAXIMUM_REQUIRED_MEMORY = 32;
    private static final int MAXIMUM_REQUIRED_NETWORK_BANDWIDTH = 12;
    protected final SolutionFileIO<CloudBalance> solutionFileIO;
    protected final File outputDir;
    protected Random random;

    public static void main(String[] args) {
        CloudBalancingGenerator generator = new CloudBalancingGenerator();
        generator.writeCloudBalance(2, 6);
        generator.writeCloudBalance(3, 9);
        generator.writeCloudBalance(4, 12);
        generator.writeCloudBalance(100, 300);
        generator.writeCloudBalance(200, 600);
        generator.writeCloudBalance(400, 1200);
        generator.writeCloudBalance(800, 2400);
        generator.writeCloudBalance(1600, 4800);
    }

    public CloudBalancingGenerator() {
        this.solutionFileIO = new XStreamSolutionFileIO(new Class[]{CloudBalance.class});
        this.outputDir = new File(CommonApp.determineDataDir("cloudbalancing"), "unsolved");
    }

    public CloudBalancingGenerator(boolean withoutDao) {
        if (!withoutDao) {
            throw new IllegalArgumentException("The parameter withoutDao (" + withoutDao + ") must be true.");
        }
        this.checkConfiguration();
        this.solutionFileIO = null;
        this.outputDir = null;
    }

    private void checkConfiguration() {
        if (CPU_POWER_PRICES.length != MEMORY_PRICES.length || CPU_POWER_PRICES.length != NETWORK_BANDWIDTH_PRICES.length) {
            throw new IllegalStateException("All price arrays must be equal in length.");
        }
    }

    private void writeCloudBalance(int computerListSize, int processListSize) {
        String fileName = this.determineFileName(computerListSize, processListSize);
        File outputFile = new File(this.outputDir, fileName + ".xml");
        CloudBalance cloudBalance = this.createCloudBalance(fileName, computerListSize, processListSize);
        this.solutionFileIO.write((Object)cloudBalance, outputFile);
        this.logger.info("Saved: {}", (Object)outputFile);
    }

    public CloudBalance createCloudBalance(int computerListSize, int processListSize) {
        return this.createCloudBalance(this.determineFileName(computerListSize, processListSize), computerListSize, processListSize);
    }

    private String determineFileName(int computerListSize, int processListSize) {
        return computerListSize + "computers-" + processListSize + "processes";
    }

    public CloudBalance createCloudBalance(String inputId, int computerListSize, int processListSize) {
        this.random = new Random(47L);
        CloudBalance cloudBalance = new CloudBalance();
        cloudBalance.setId(0L);
        this.createComputerList(cloudBalance, computerListSize);
        this.createProcessList(cloudBalance, processListSize);
        this.assureComputerCapacityTotalAtLeastProcessRequiredTotal(cloudBalance);
        BigInteger possibleSolutionSize = BigInteger.valueOf(cloudBalance.getComputerList().size()).pow(cloudBalance.getProcessList().size());
        this.logger.info("CloudBalance {} has {} computers and {} processes with a search space of {}.", new Object[]{inputId, computerListSize, processListSize, AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return cloudBalance;
    }

    private void createComputerList(CloudBalance cloudBalance, int computerListSize) {
        ArrayList<CloudComputer> computerList = new ArrayList<CloudComputer>(computerListSize);
        for (int i = 0; i < computerListSize; ++i) {
            CloudComputer computer = this.generateComputerWithoutId();
            computer.setId(Long.valueOf(i));
            computerList.add(computer);
        }
        cloudBalance.setComputerList(computerList);
    }

    public CloudComputer generateComputerWithoutId() {
        CloudComputer computer = new CloudComputer();
        int cpuPowerPricesIndex = this.random.nextInt(CPU_POWER_PRICES.length);
        computer.setCpuPower(CPU_POWER_PRICES[cpuPowerPricesIndex].getHardwareValue());
        int memoryPricesIndex = this.distortIndex(cpuPowerPricesIndex, MEMORY_PRICES.length);
        computer.setMemory(MEMORY_PRICES[memoryPricesIndex].getHardwareValue());
        int networkBandwidthPricesIndex = this.distortIndex(cpuPowerPricesIndex, NETWORK_BANDWIDTH_PRICES.length);
        computer.setNetworkBandwidth(NETWORK_BANDWIDTH_PRICES[networkBandwidthPricesIndex].getHardwareValue());
        int cost = CPU_POWER_PRICES[cpuPowerPricesIndex].getCost() + MEMORY_PRICES[memoryPricesIndex].getCost() + NETWORK_BANDWIDTH_PRICES[networkBandwidthPricesIndex].getCost();
        computer.setCost(cost);
        this.logger.trace("Created computer with cpuPowerPricesIndex ({}), memoryPricesIndex ({}), networkBandwidthPricesIndex ({}).", new Object[]{cpuPowerPricesIndex, memoryPricesIndex, networkBandwidthPricesIndex});
        return computer;
    }

    private int distortIndex(int referenceIndex, int length) {
        int index = referenceIndex;
        double randomDouble = this.random.nextDouble();
        for (double loweringThreshold = 0.25; randomDouble < loweringThreshold && index >= 1; --index, loweringThreshold *= 0.1) {
        }
        double heighteningThreshold = 0.75;
        while (randomDouble >= heighteningThreshold && index <= length - 2) {
            ++index;
            heighteningThreshold = 1.0 - (1.0 - heighteningThreshold) * 0.1;
        }
        return index;
    }

    private void createProcessList(CloudBalance cloudBalance, int processListSize) {
        ArrayList<CloudProcess> processList = new ArrayList<CloudProcess>(processListSize);
        for (int i = 0; i < processListSize; ++i) {
            CloudProcess process = this.generateProcessWithoutId();
            process.setId(Long.valueOf(i));
            processList.add(process);
        }
        cloudBalance.setProcessList(processList);
    }

    public CloudProcess generateProcessWithoutId() {
        CloudProcess process = new CloudProcess();
        int requiredCpuPower = this.generateRandom(12);
        process.setRequiredCpuPower(requiredCpuPower);
        int requiredMemory = this.generateRandom(32);
        process.setRequiredMemory(requiredMemory);
        int requiredNetworkBandwidth = this.generateRandom(12);
        process.setRequiredNetworkBandwidth(requiredNetworkBandwidth);
        this.logger.trace("Created CloudProcess with requiredCpuPower ({}), requiredMemory ({}), requiredNetworkBandwidth ({}).", new Object[]{requiredCpuPower, requiredMemory, requiredNetworkBandwidth});
        return process;
    }

    private int generateRandom(int maximumValue) {
        double parabolaBase = 2000.0;
        double randomDouble = this.random.nextDouble();
        double parabolaRandomDouble = (Math.pow(parabolaBase, randomDouble) - 1.0) / (parabolaBase - 1.0);
        if (parabolaRandomDouble < 0.0 || parabolaRandomDouble >= 1.0) {
            throw new IllegalArgumentException("Invalid generated parabolaRandomDouble (" + parabolaRandomDouble + ")");
        }
        int value = (int)Math.floor(parabolaRandomDouble * (double)maximumValue) + 1;
        if (value < 1 || value > maximumValue) {
            throw new IllegalArgumentException("Invalid generated value (" + value + ")");
        }
        return value;
    }

    private void assureComputerCapacityTotalAtLeastProcessRequiredTotal(CloudBalance cloudBalance) {
        int upgrade;
        int upgrade2;
        int upgrade3;
        List<CloudComputer> computerList = cloudBalance.getComputerList();
        int cpuPowerTotal = 0;
        int memoryTotal = 0;
        int networkBandwidthTotal = 0;
        for (CloudComputer computer : computerList) {
            cpuPowerTotal += computer.getCpuPower();
            memoryTotal += computer.getMemory();
            networkBandwidthTotal += computer.getNetworkBandwidth();
        }
        int requiredCpuPowerTotal = 0;
        int requiredMemoryTotal = 0;
        int requiredNetworkBandwidthTotal = 0;
        for (CloudProcess process : cloudBalance.getProcessList()) {
            requiredCpuPowerTotal += process.getRequiredCpuPower();
            requiredMemoryTotal += process.getRequiredMemory();
            requiredNetworkBandwidthTotal += process.getRequiredNetworkBandwidth();
        }
        for (int cpuPowerLacking = requiredCpuPowerTotal - cpuPowerTotal; cpuPowerLacking > 0; cpuPowerLacking -= upgrade3) {
            CloudComputer computer = computerList.get(this.random.nextInt(computerList.size()));
            upgrade3 = this.determineUpgrade(cpuPowerLacking);
            computer.setCpuPower(computer.getCpuPower() + upgrade3);
        }
        for (int memoryLacking = requiredMemoryTotal - memoryTotal; memoryLacking > 0; memoryLacking -= upgrade2) {
            CloudComputer computer = computerList.get(this.random.nextInt(computerList.size()));
            upgrade2 = this.determineUpgrade(memoryLacking);
            computer.setMemory(computer.getMemory() + upgrade2);
        }
        for (int networkBandwidthLacking = requiredNetworkBandwidthTotal - networkBandwidthTotal; networkBandwidthLacking > 0; networkBandwidthLacking -= upgrade) {
            CloudComputer computer = computerList.get(this.random.nextInt(computerList.size()));
            upgrade = this.determineUpgrade(networkBandwidthLacking);
            computer.setNetworkBandwidth(computer.getNetworkBandwidth() + upgrade);
        }
    }

    private int determineUpgrade(int lacking) {
        for (int upgrade : new int[]{8, 4, 2, 1}) {
            if (lacking < upgrade) continue;
            return upgrade;
        }
        throw new IllegalStateException("Lacking (" + lacking + ") should be at least 1.");
    }

    private static class Price {
        private int hardwareValue;
        private String description;
        private int cost;

        private Price(int hardwareValue, String description, int cost) {
            this.hardwareValue = hardwareValue;
            this.description = description;
            this.cost = cost;
        }

        public int getHardwareValue() {
            return this.hardwareValue;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCost() {
            return this.cost;
        }
    }
}

