/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.scrabble.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.drools.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.scrabble.domain.ScrabbleCell;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordAssignment;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordDirection;
import org.optaplanner.persistence.xstream.api.score.buildin.hardmediumsoft.HardMediumSoftScoreXStreamConverter;

@PlanningSolution
@XStreamAlias(value="ScrabbleSolution")
public class ScrabbleSolution
extends AbstractPersistable {
    private int gridWidth;
    private int gridHeight;
    @ValueRangeProvider(id="startCellRange")
    @ProblemFactCollectionProperty
    private List<ScrabbleCell> cellList;
    @PlanningEntityCollectionProperty
    private List<ScrabbleWordAssignment> wordList;
    @XStreamConverter(value=HardMediumSoftScoreXStreamConverter.class)
    private HardMediumSoftScore score;

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int gridHeight) {
        this.gridHeight = gridHeight;
    }

    public List<ScrabbleCell> getCellList() {
        return this.cellList;
    }

    public void setCellList(List<ScrabbleCell> cellList) {
        this.cellList = cellList;
    }

    public List<ScrabbleWordAssignment> getWordList() {
        return this.wordList;
    }

    public void setWordList(List<ScrabbleWordAssignment> wordList) {
        this.wordList = wordList;
    }

    @PlanningScore
    public HardMediumSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardMediumSoftScore score) {
        this.score = score;
    }

    @ValueRangeProvider(id="directionRange")
    public ScrabbleWordDirection[] getDirectionRange() {
        return ScrabbleWordDirection.values();
    }

    public ScrabbleCell getCell(int x, int y) {
        return this.cellList.get(x * this.gridWidth + y);
    }
}

