/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.app;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.optional.realtime.AddComputerProblemFactChange;
import org.optaplanner.examples.cloudbalancing.optional.realtime.AddProcessProblemFactChange;
import org.optaplanner.examples.cloudbalancing.optional.realtime.DeleteComputerProblemFactChange;
import org.optaplanner.examples.cloudbalancing.optional.realtime.DeleteProcessProblemFactChange;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;
import org.optaplanner.examples.common.app.RealTimePlanningTurtleTest;

public class CloudBalancingRealTimePlanningTurtleTest
extends RealTimePlanningTurtleTest<CloudBalance> {
    private CloudBalancingGenerator generator = new CloudBalancingGenerator(true);
    private List<CloudComputer> existingComputerList;
    private List<CloudProcess> existingProcessList;

    @Override
    protected String createSolverConfigResource() {
        return "org/optaplanner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml";
    }

    @Override
    protected CloudBalance readPlanningProblem() {
        CloudBalance cloudBalance = this.generator.createCloudBalance(1200, 4800);
        this.existingComputerList = new ArrayList<CloudComputer>(cloudBalance.getComputerList());
        this.existingProcessList = new ArrayList<CloudProcess>(cloudBalance.getProcessList());
        return cloudBalance;
    }

    @Override
    protected ProblemFactChange<CloudBalance> nextProblemFactChange(Random random) {
        boolean capacityTooHigh;
        boolean capacityTooLow = this.existingComputerList.size() <= 20 || this.existingComputerList.size() < this.existingProcessList.size() / 4;
        boolean bl = capacityTooHigh = this.existingComputerList.size() > this.existingProcessList.size() / 2;
        if (random.nextBoolean()) {
            if (capacityTooLow || !capacityTooHigh && random.nextBoolean()) {
                CloudComputer computer = this.generator.generateComputerWithoutId();
                this.existingComputerList.add(computer);
                return new AddComputerProblemFactChange(computer);
            }
            return new DeleteComputerProblemFactChange(this.existingComputerList.remove(random.nextInt(this.existingComputerList.size())));
        }
        if (capacityTooHigh || !capacityTooLow && random.nextBoolean()) {
            CloudProcess process = this.generator.generateProcessWithoutId();
            this.existingProcessList.add(process);
            return new AddProcessProblemFactChange(process);
        }
        return new DeleteProcessProblemFactChange(this.existingProcessList.remove(random.nextInt(this.existingProcessList.size())));
    }
}

